/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.extension.plugins;

import cn.easyes.annotation.Intercepts;
import cn.easyes.annotation.Signature;
import cn.easyes.common.utils.ExceptionUtils;
import cn.easyes.extension.context.Interceptor;
import cn.easyes.extension.context.Invocation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Plugin
implements InvocationHandler {
    private final Object target;
    private final Interceptor interceptor;
    private final Map<Class<?>, Set<Method>> signatureMap;

    private Plugin(Object target, Interceptor interceptor, Map<Class<?>, Set<Method>> signatureMap) {
        this.target = target;
        this.interceptor = interceptor;
        this.signatureMap = signatureMap;
    }

    public static <T> T wrap(T t, Interceptor interceptor) {
        Map<Class<?>, Set<Method>> signatureMap = Plugin.getSignatureMap(interceptor);
        return (T)Proxy.newProxyInstance(t.getClass().getClassLoader(), t.getClass().getInterfaces(), (InvocationHandler)new Plugin(t, interceptor, signatureMap));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Set<Method> methods = this.signatureMap.get(method.getDeclaringClass());
            if (methods != null && methods.contains(method)) {
                return this.interceptor.intercept(new Invocation(this.target, method, args));
            }
            return method.invoke(this.target, args);
        }
        catch (Exception e) {
            throw ExceptionUtils.unwrapThrowable((Throwable)e);
        }
    }

    private static Map<Class<?>, Set<Method>> getSignatureMap(Interceptor interceptor) {
        Intercepts interceptsAnnotation = interceptor.getClass().getAnnotation(Intercepts.class);
        if (interceptsAnnotation == null) {
            throw new RuntimeException("No @Intercepts annotation was found in interceptor " + interceptor.getClass().getName());
        }
        Signature[] sigs = interceptsAnnotation.value();
        HashMap signatureMap = new HashMap();
        for (Signature sig : sigs) {
            Set methods = signatureMap.computeIfAbsent(sig.type(), k -> new HashSet());
            try {
                Method method = sig.type().getMethod(sig.method(), sig.args());
                methods.add(method);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Could not find method on " + sig.type() + " named " + sig.method() + ". Cause: " + e, e);
            }
        }
        return signatureMap;
    }
}

