/*
 * Decompiled with CFR 0.152.
 */
package cn.elegent.security.annotation.aspect;

import cn.elegent.security.annotation.core.ElegentNoAuthResponse;
import cn.elegent.security.annotation.util.ReflectionUtil;
import cn.elegent.security.common.base.UserDetails;
import cn.elegent.security.common.context.SubjectContext;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class JSR250Aspect {
    @Autowired
    private ElegentNoAuthResponse elegentNoAuthResponse;

    @Pointcut(value="@annotation(javax.annotation.security.RolesAllowed)")
    public void RolesAllowed() {
    }

    @Around(value="RolesAllowed()")
    public Object rolesAllowedAspect(ProceedingJoinPoint point) throws Throwable {
        UserDetails userDetails = SubjectContext.getSubject();
        if (!userDetails.isEnabled()) {
            return this.elegentNoAuthResponse.noAuthInterview(point);
        }
        if (userDetails.isSuperUser()) {
            return point.proceed(point.getArgs());
        }
        List userRoles = userDetails.getRoles();
        if (userRoles == null) {
            return this.elegentNoAuthResponse.noAuthInterview(point);
        }
        Method method = ReflectionUtil.getMethodByProceedingJoinPoint(point);
        RolesAllowed rolesAllowed = method.getAnnotation(RolesAllowed.class);
        String[] resourceRoles = rolesAllowed.value();
        long count = Arrays.stream(resourceRoles).filter(role -> userRoles.contains(role)).count();
        if (count > 0L) {
            return point.proceed(point.getArgs());
        }
        return this.elegentNoAuthResponse.noAuthInterview(point);
    }
}

