/*
 * Decompiled with CFR 0.152.
 */
package cn.elegent.security.annotation.noauth;

import cn.elegent.security.annotation.core.ElegentNoAuthResponse;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class DefaultElegentNoAuthResponse
implements ElegentNoAuthResponse {
    @Override
    public Object noAuthInterview(ProceedingJoinPoint point) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletResponse response = attributes.getResponse();
        response.setStatus(HttpStatus.FORBIDDEN.value());
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        Class<?> returnType = method.getReturnType();
        boolean primitive = returnType.isPrimitive();
        if (primitive) {
            return this.getDefaultResult(returnType);
        }
        return null;
    }

    private Object getDefaultResult(Class returnType) {
        if (Integer.TYPE.equals(returnType)) {
            return -1;
        }
        if (Boolean.TYPE.equals(returnType)) {
            return false;
        }
        if (Long.TYPE.equals(returnType)) {
            return -1L;
        }
        if (Byte.TYPE.equals(returnType)) {
            return -1;
        }
        if (Short.TYPE.equals(returnType)) {
            return -1;
        }
        if (Float.TYPE.equals(returnType)) {
            return -1;
        }
        if (Double.TYPE.equals(returnType)) {
            return -1;
        }
        if (Character.TYPE.equals(returnType)) {
            return Character.valueOf('n');
        }
        return null;
    }
}

