/*
 * Decompiled with CFR 0.152.
 */
package cn.elegent.security.common.util;

import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class JWTUtils {
    public static String createJWT(String id, Map<String, Object> claims, String key, int expire, TimeUnit timeUnit) {
        SecretKey secretKey = JWTUtils.generalKey(key);
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = JWTUtils.getEndDate(expire, timeUnit, zoneId);
        Date endTime = Date.from(zdt.toInstant());
        JwtBuilder builder = Jwts.builder().setHeaderParam("typ", (Object)"JWT").setId(id).setIssuedAt(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant())).addClaims(claims).setExpiration(endTime).signWith(SignatureAlgorithm.HS256, (Key)secretKey);
        return builder.compact();
    }

    public static Object verifyJWT(String token, String secret) {
        SecretKey key = JWTUtils.generalKey(secret);
        try {
            Jws jwt = Jwts.parser().setSigningKey((Key)key).parseClaimsJws(token);
            return jwt.getBody();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static SecretKey generalKey(String jwtSecret) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        byte[] encodedKey = Base64.getMimeDecoder().decode(jwtSecret);
        SecretKeySpec key = new SecretKeySpec(encodedKey, signatureAlgorithm.getJcaName());
        return key;
    }

    public static ZonedDateTime getEndDate(int expire, TimeUnit unit, ZoneId zoneId) {
        switch (unit) {
            case DAYS: {
                return LocalDateTime.now().plusDays(expire).atZone(zoneId);
            }
            case HOURS: {
                return LocalDateTime.now().plusHours(expire).atZone(zoneId);
            }
            case MINUTES: {
                return LocalDateTime.now().plusMinutes(expire).atZone(zoneId);
            }
            case SECONDS: {
                return LocalDateTime.now().plusSeconds(expire).atZone(zoneId);
            }
        }
        return null;
    }
}

