/*
 * Decompiled with CFR 0.152.
 */
package cn.elegent.security.verifier.web.filter;

import cn.elegent.security.common.base.AuthorizationResult;
import cn.elegent.security.verifier.core.AccessDeniedHandler;
import cn.elegent.security.verifier.core.AuthenticationEntryPoint;
import cn.elegent.security.verifier.core.AuthorizationManager;
import cn.elegent.security.verifier.core.TokenAcquirer;
import cn.elegent.security.verifier.web.util.ServletRequestUtil;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthenticationFilter
implements Filter {
    private AuthorizationManager<HttpServletRequest, HttpServletResponse> authorizationManager;
    private TokenAcquirer tokenAcquirer;
    private AuthenticationEntryPoint<HttpServletRequest, HttpServletResponse> authenticationEntryPoint;
    private AccessDeniedHandler<HttpServletRequest, HttpServletResponse> accessDeniedHandler;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        AuthorizationResult authorizationResult = this.authorizationManager.check((Object)request, (Object)response);
        if (authorizationResult.getCheckResult() == 1) {
            if (authorizationResult.getUserDetails() != null) {
                String userDetails = URLEncoder.encode(JSON.toJSONString((Object)authorizationResult.getUserDetails()), "UTF-8");
                HashMap<String, String> headerMap = new HashMap<String, String>();
                headerMap.put("elegentUser", userDetails);
                ServletRequestUtil.addHeader(request, headerMap);
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
        if (authorizationResult.getCheckResult() == 0) {
            this.authenticationEntryPoint.commence((Object)request, (Object)response);
        }
        if (authorizationResult.getCheckResult() == -1) {
            this.accessDeniedHandler.handle((Object)request, (Object)response);
        }
    }

    AuthenticationFilter(AuthorizationManager<HttpServletRequest, HttpServletResponse> authorizationManager, TokenAcquirer tokenAcquirer, AuthenticationEntryPoint<HttpServletRequest, HttpServletResponse> authenticationEntryPoint, AccessDeniedHandler<HttpServletRequest, HttpServletResponse> accessDeniedHandler) {
        this.authorizationManager = authorizationManager;
        this.tokenAcquirer = tokenAcquirer;
        this.authenticationEntryPoint = authenticationEntryPoint;
        this.accessDeniedHandler = accessDeniedHandler;
    }

    public static AuthenticationFilterBuilder builder() {
        return new AuthenticationFilterBuilder();
    }

    public static class AuthenticationFilterBuilder {
        private AuthorizationManager<HttpServletRequest, HttpServletResponse> authorizationManager;
        private TokenAcquirer tokenAcquirer;
        private AuthenticationEntryPoint<HttpServletRequest, HttpServletResponse> authenticationEntryPoint;
        private AccessDeniedHandler<HttpServletRequest, HttpServletResponse> accessDeniedHandler;

        AuthenticationFilterBuilder() {
        }

        public AuthenticationFilterBuilder authorizationManager(AuthorizationManager<HttpServletRequest, HttpServletResponse> authorizationManager) {
            this.authorizationManager = authorizationManager;
            return this;
        }

        public AuthenticationFilterBuilder tokenAcquirer(TokenAcquirer tokenAcquirer) {
            this.tokenAcquirer = tokenAcquirer;
            return this;
        }

        public AuthenticationFilterBuilder authenticationEntryPoint(AuthenticationEntryPoint<HttpServletRequest, HttpServletResponse> authenticationEntryPoint) {
            this.authenticationEntryPoint = authenticationEntryPoint;
            return this;
        }

        public AuthenticationFilterBuilder accessDeniedHandler(AccessDeniedHandler<HttpServletRequest, HttpServletResponse> accessDeniedHandler) {
            this.accessDeniedHandler = accessDeniedHandler;
            return this;
        }

        public AuthenticationFilter build() {
            return new AuthenticationFilter(this.authorizationManager, this.tokenAcquirer, this.authenticationEntryPoint, this.accessDeniedHandler);
        }

        public String toString() {
            return "AuthenticationFilter.AuthenticationFilterBuilder(authorizationManager=" + this.authorizationManager + ", tokenAcquirer=" + this.tokenAcquirer + ", authenticationEntryPoint=" + this.authenticationEntryPoint + ", accessDeniedHandler=" + this.accessDeniedHandler + ")";
        }
    }
}

