/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.core.pojo.mybatis;

import cn.ezeyc.core.config.Const;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedJdbcTypes(value={JdbcType.VARCHAR})
@MappedTypes(value={Double[].class})
public class DoubleArrayTypeHandler
extends BaseTypeHandler<Double[]> {
    private static final Logger log = LoggerFactory.getLogger(DoubleArrayTypeHandler.class);

    public void setNonNullParameter(PreparedStatement preparedStatement, int i, Double[] objects, JdbcType jdbcType) throws SQLException {
        preparedStatement.setString(i, Arrays.stream(objects).map(Object::toString).collect(Collectors.joining(Const.dou)));
    }

    public Double[] getNullableResult(ResultSet resultSet, String s) throws SQLException {
        String v = resultSet.getString(s);
        if (v != null && !"".equals(v)) {
            Double[] result = new Double[v.length()];
            for (int x = 0; x < v.split(Const.dou).length; ++x) {
                result[x] = Double.valueOf(v.split(Const.dou)[x]);
            }
            return result;
        }
        return null;
    }

    public Double[] getNullableResult(ResultSet resultSet, int i) throws SQLException {
        String v = resultSet.getString(i);
        if (v != null) {
            Double[] result = new Double[v.length()];
            for (int x = 0; x < v.split(Const.dou).length; ++x) {
                result[x] = Double.valueOf(v.split(Const.dou)[x]);
            }
            return result;
        }
        return null;
    }

    public Double[] getNullableResult(CallableStatement callableStatement, int i) throws SQLException {
        String v = callableStatement.getString(i);
        if (v != null) {
            Double[] result = new Double[v.length()];
            for (int x = 0; x < v.split(Const.dou).length; ++x) {
                result[x] = Double.valueOf(v.split(Const.dou)[x]);
            }
            return result;
        }
        return null;
    }
}

