/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.core.pojo.mybatis;

import cn.ezeyc.core.config.Const;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedJdbcTypes(value={JdbcType.VARCHAR})
@MappedTypes(value={Integer[].class})
public class IntegerArrayTypeHandler
extends BaseTypeHandler<Integer[]> {
    private static final Logger log = LoggerFactory.getLogger(IntegerArrayTypeHandler.class);

    public void setNonNullParameter(PreparedStatement preparedStatement, int i, Integer[] objects, JdbcType jdbcType) throws SQLException {
        preparedStatement.setString(i, Arrays.stream(objects).map(Object::toString).collect(Collectors.joining(Const.dou)));
    }

    public Integer[] getNullableResult(ResultSet resultSet, String s) throws SQLException {
        String v = resultSet.getString(s);
        if (v != null && !"".equals(v)) {
            Integer[] result = new Integer[v.length()];
            for (int x = 0; x < v.split(Const.dou).length; ++x) {
                result[x] = Integer.valueOf(v.split(Const.dou)[x]);
            }
            return result;
        }
        return null;
    }

    public Integer[] getNullableResult(ResultSet resultSet, int i) throws SQLException {
        String v = resultSet.getString(i);
        if (v != null) {
            Integer[] result = new Integer[v.length()];
            for (int x = 0; x < v.split(Const.dou).length; ++x) {
                result[x] = Integer.valueOf(v.split(Const.dou)[x]);
            }
            return result;
        }
        return null;
    }

    public Integer[] getNullableResult(CallableStatement callableStatement, int i) throws SQLException {
        String v = callableStatement.getString(i);
        if (v != null) {
            Integer[] result = new Integer[v.length()];
            for (int x = 0; x < v.split(Const.dou).length; ++x) {
                result[x] = Integer.valueOf(v.split(Const.dou)[x]);
            }
            return result;
        }
        return null;
    }
}

