/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.core.pojo.mybatis;

import cn.ezeyc.core.config.Const;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedJdbcTypes(value={JdbcType.VARCHAR})
@MappedTypes(value={Long[].class})
public class LongArrayTypeHandler
extends BaseTypeHandler<Long[]> {
    private static final Logger log = LoggerFactory.getLogger(LongArrayTypeHandler.class);

    public void setNonNullParameter(PreparedStatement preparedStatement, int i, Long[] objects, JdbcType jdbcType) throws SQLException {
        preparedStatement.setString(i, Arrays.stream(objects).map(Object::toString).collect(Collectors.joining(Const.dou)));
    }

    public Long[] getNullableResult(ResultSet resultSet, String s) throws SQLException {
        String v = resultSet.getString(s);
        if (v != null && !"".equals(v)) {
            Long[] result = new Long[v.split(Const.dou).length];
            for (int x = 0; x < v.split(Const.dou).length; ++x) {
                result[x] = Long.valueOf(v.split(Const.dou)[x]);
            }
            return result;
        }
        return null;
    }

    public Long[] getNullableResult(ResultSet resultSet, int i) throws SQLException {
        String v = resultSet.getString(i);
        if (v != null) {
            Long[] result = new Long[v.length()];
            for (int x = 0; x < v.split(Const.dou).length; ++x) {
                result[x] = Long.valueOf(v.split(Const.dou)[x]);
            }
            return result;
        }
        return null;
    }

    public Long[] getNullableResult(CallableStatement callableStatement, int i) throws SQLException {
        String v = callableStatement.getString(i);
        if (v != null) {
            Long[] result = new Long[v.length()];
            for (int x = 0; x < v.split(Const.dou).length; ++x) {
                result[x] = Long.valueOf(v.split(Const.dou)[x]);
            }
            return result;
        }
        return null;
    }
}

