/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.core.sso;

import cn.dev33.satoken.sso.SaSsoHandle;
import cn.dev33.satoken.sso.SaSsoManager;
import cn.dev33.satoken.sso.SaSsoUtil;
import cn.dev33.satoken.stp.StpUtil;
import cn.ezeyc.core.enums.ResultEnum;
import cn.ezeyc.core.pojo.ResultBody;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Param;
import org.noear.solon.core.handle.Context;

@Controller
public class SsoClientControl {
    @Mapping(value="/sso/*")
    public ResultBody ssoRequest() {
        return ResultBody.success(SaSsoHandle.clientRequest());
    }

    @Mapping(value="/sso/isLogin")
    public ResultBody isLogin() {
        return ResultBody.success(StpUtil.isLogin());
    }

    @Mapping(value="/sso/getSsoAuthUrl")
    public ResultBody getSsoAuthUrl(@Param(value="clientLoginUrl") String clientLoginUrl, @Param(value="backUrl") String backUrl) {
        String serverAuthUrl = SaSsoUtil.buildServerAuthUrl((String)clientLoginUrl, (String)backUrl);
        if (serverAuthUrl.startsWith("/sso/auth")) {
            return ResultBody.failed(ResultEnum.ssoError);
        }
        return ResultBody.success(serverAuthUrl);
    }

    @Mapping(value="/sso/doLoginByTicket")
    public ResultBody doLoginByTicket(@Param(value="ticket") String ticket) {
        Object loginId = SaSsoHandle.checkTicket((String)ticket, (String)"/sso/doLoginByTicket");
        if (loginId != null) {
            StpUtil.login((Object)loginId);
            return ResultBody.success(StpUtil.getTokenValue());
        }
        return ResultBody.failed("\u65e0\u6548ticket\uff1a" + ticket);
    }

    @Mapping(value="/sso/myInfo")
    public Object myInfo(Context ctx) {
        String url = SaSsoUtil.addSignParams((String)SaSsoManager.getConfig().splicingUserinfoUrl(), (Object)StpUtil.getLoginId());
        url = url + "&token=" + ctx.header("token");
        return SaSsoManager.getConfig().getSendHttp().apply(url);
    }
}

