/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.core.util;

import cn.ezeyc.core.annotation.Excel;
import cn.ezeyc.core.pojo.MyRuntimeException;
import cn.ezeyc.core.util.ClassUtil;
import cn.ezeyc.core.util.RedisUtil;
import cn.ezeyc.core.util.reflect;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.nacos.common.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.noear.solon.core.handle.Context;

public class ExcelUtil {
    public static void pcExportExcel(RedisUtil redisUtil, List list) {
        ExcelUtil.pcExportExcel(redisUtil, list, null, null);
    }

    public static void pcExportExcel(List list) {
        ExcelUtil.pcExportExcel(null, list, null, null);
    }

    public static void pcExportExcelName(RedisUtil redisUtil, List list, String fileName) {
        ExcelUtil.pcExportExcel(redisUtil, list, null, fileName);
    }

    public static void pcExportExcelName(List list, String fileName) {
        ExcelUtil.pcExportExcel(null, list, null, fileName);
    }

    public static void pcExportExcel(RedisUtil redisUtil, List list, String title) {
        ExcelUtil.pcExportExcel(redisUtil, list, title, null);
    }

    public static void pcExportExcel(List list, String title) {
        ExcelUtil.pcExportExcel(null, list, title, null);
    }

    public static void pcExportExcel(RedisUtil redisUtil, List list, String title, String fileName) {
        ExcelUtil.export(list, null, title, fileName, true, redisUtil);
    }

    public static void pcExportExcel(List list, String title, String fileName) {
        ExcelUtil.export(list, null, title, fileName, true, null);
    }

    public static void exportExcel(List list, String path) {
        ExcelUtil.exportExcel(null, list, path, null);
    }

    public static void exportExcel(RedisUtil redisUtil, List list, String path) {
        ExcelUtil.exportExcel(redisUtil, list, path, null);
    }

    public static void exportExcel(List list, String path, String title) {
        ExcelUtil.exportExcel(null, list, path, title, null);
    }

    public static void exportExcel(RedisUtil redisUtil, List list, String path, String title) {
        ExcelUtil.exportExcel(redisUtil, list, path, title, null);
    }

    public static void exportExcel(List list, String path, String title, String fileName) {
        ExcelUtil.export(list, path, title, fileName, false, null);
    }

    public static void exportExcel(RedisUtil redisUtil, List list, String path, String title, String fileName) {
        ExcelUtil.export(list, path, title, fileName, false, redisUtil);
    }

    private static void export(List list, String path, String title, String fileName, Boolean pc, RedisUtil redisUtil) {
        Object cells;
        Integer titles;
        XSSFWorkbook work = new XSSFWorkbook();
        Sheet sheet = work.createSheet();
        Field[] field = ClassUtil.getAllFields(list.get(0).getClass(), Excel.class);
        List fields = Arrays.stream(field).sorted((o1, o2) -> o1.getAnnotation(Excel.class).index() - o2.getAnnotation(Excel.class).index()).collect(Collectors.toList());
        Integer rowInt = 0;
        if (title != null && !"".equals(title)) {
            CellRangeAddress cellAddresses = new CellRangeAddress(0, 0, 0, fields.size());
            sheet.addMergedRegion(cellAddresses);
            Integer n = rowInt;
            Integer n2 = rowInt = Integer.valueOf(rowInt + 1);
            titles = sheet.createRow(n.intValue());
            cells = titles.createCell(0);
            cells.setCellValue(title);
            RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellAddresses, (Sheet)sheet);
            RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellAddresses, (Sheet)sheet);
            RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellAddresses, (Sheet)sheet);
            RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellAddresses, (Sheet)sheet);
        }
        if (fields.size() > 0) {
            titles = rowInt;
            rowInt = rowInt + 1;
            cells = rowInt;
            Row row = sheet.createRow(titles.intValue());
            int c = 0;
            for (Object f : fields) {
                Excel annotation = ((Field)f).getAnnotation(Excel.class);
                if (annotation.type() != Excel.Type.ALL && annotation.type() != Excel.Type.EXPORT) continue;
                Cell cell = row.createCell(c++);
                cell.setCellValue(annotation.name());
            }
        }
        for (Object o : list) {
            Object f;
            f = rowInt;
            rowInt = rowInt + 1;
            Integer n = rowInt;
            Row row = sheet.createRow(((Integer)f).intValue());
            int c = 0;
            block6: for (Field f2 : fields) {
                Excel annotation = f2.getAnnotation(Excel.class);
                if (annotation.type() != Excel.Type.ALL && annotation.type() != Excel.Type.EXPORT) continue;
                Cell cell = row.createCell(c++);
                try {
                    f2.setAccessible(true);
                    if (!("".equals(annotation.dateFormat()) || f2.get(o) == null || f2.getType() != LocalDateTime.class && f2.getType() != LocalTime.class && f2.getType() != LocalDate.class)) {
                        cell.setCellValue(ExcelUtil.parseDate(f2, f2.getType(), f2.get(o).toString(), annotation.dateFormat()));
                        continue;
                    }
                    if (!"".equals(annotation.dictType()) && redisUtil != null) {
                        JSONArray vals;
                        Object obj = redisUtil.getByString(annotation.dictType());
                        if (obj == null || !(obj instanceof JSONObject) || (vals = ((JSONObject)obj).getJSONArray("list")) == null || vals.size() <= 0) continue;
                        for (Object j : vals) {
                            if (j == null || !(j instanceof JSONObject) || !((JSONObject)j).get("val").equals(f2.get(o).toString())) continue;
                            cell.setCellValue(((JSONObject)j).get("label").toString());
                            continue block6;
                        }
                        continue;
                    }
                    if (!"".equals(annotation.readConverterExp())) {
                        String[] split = annotation.readConverterExp().split(",");
                        if (split.length <= 0) continue;
                        for (String s : split) {
                            String[] v = s.split("=");
                            if (v.length <= 0 || !v[0].equals(f2.get(o).toString())) continue;
                            cell.setCellValue(v[1]);
                            continue block6;
                        }
                        continue;
                    }
                    if (!"".equals(annotation.suffix())) {
                        cell.setCellValue(f2.get(o).toString() + annotation.suffix());
                        continue;
                    }
                    if (f2.get(o) == null) continue;
                    if (f2.getType().isArray()) {
                        if (f2.getType().getSimpleName().contains("String")) {
                            cell.setCellValue(StringUtils.join(Arrays.asList((String[])f2.get(o)), (String)","));
                            continue;
                        }
                        if (f2.getType().getSimpleName().contains("Long")) {
                            cell.setCellValue(StringUtils.join(Arrays.asList((Long[])f2.get(o)), (String)","));
                            continue;
                        }
                        if (f2.getType().getSimpleName().contains("Double")) {
                            cell.setCellValue(StringUtils.join(Arrays.asList((Double[])f2.get(o)), (String)","));
                            continue;
                        }
                        if (!f2.getType().getSimpleName().contains("Float")) continue;
                        cell.setCellValue(StringUtils.join(Arrays.asList((Float[])f2.get(o)), (String)","));
                        continue;
                    }
                    cell.setCellValue(f2.get(o).toString());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        try {
            if (fileName == null || "".equals(fileName)) {
                fileName = "\u8868\u683c.xlsx";
            }
            if (pc.booleanValue()) {
                ExcelUtil.download((Workbook)work, fileName);
            } else {
                ExcelUtil.write((Workbook)work, fileName, path);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String parseDate(Field f, Class c, String value, String pattern) {
        if (value != null && !"".equals(value) && c == LocalDate.class) {
            LocalDate localDate = ExcelUtil.setDate(f.getName(), "yyyy-MM-dd", value).toLocalDate();
            return localDate.format(DateTimeFormatter.ofPattern(pattern));
        }
        if (value != null && !"".equals(value) && c == LocalDateTime.class) {
            if (String.valueOf(value).contains("Z")) {
                LocalDateTime localDateTime = ExcelUtil.setDate(f.getName(), "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", value);
                return localDateTime.format(DateTimeFormatter.ofPattern(pattern));
            }
            if (String.valueOf(value).contains("T")) {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
                LocalDateTime localDateTime = ExcelUtil.setDate(f.getName(), "yyyy-MM-dd'T'HH:mm:ss", dateTimeFormatter.format(LocalDateTime.parse(value.toString())));
                return localDateTime.format(DateTimeFormatter.ofPattern(pattern));
            }
            LocalDateTime localDateTime = ExcelUtil.setDate(f.getName(), "yyyy-MM-dd HH:mm:ss", value);
            return localDateTime.format(DateTimeFormatter.ofPattern(pattern));
        }
        if (value != null && !"".equals(value) && c == LocalTime.class) {
            LocalDateTime localDateTime = ExcelUtil.setDate(f.getName(), "HH:mm:ss", value);
            return localDateTime.toLocalTime().format(DateTimeFormatter.ofPattern(pattern));
        }
        return null;
    }

    private static LocalDateTime setDate(String field, String format, Object value) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date utcDate = null;
        try {
            utcDate = sdf.parse(String.valueOf(value));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Instant instant = utcDate.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDateTime();
    }

    public static List importExcel(File file, Class entity, RedisUtil redisUtil) {
        ArrayList list = new ArrayList();
        try {
            FileInputStream is = new FileInputStream(file);
            Field[] fields = ClassUtil.getAllFields(entity, Excel.class);
            XSSFWorkbook book = new XSSFWorkbook((InputStream)is);
            XSSFSheet sheet = book.getSheetAt(0);
            int rows = sheet.getPhysicalNumberOfRows();
            HashMap<Integer, String> cell = new HashMap<Integer, String>();
            for (int x = 0; x < rows; ++x) {
                XSSFRow row = sheet.getRow(x);
                if (x == 0) {
                    block3: for (int y = 0; y < row.getPhysicalNumberOfCells(); ++y) {
                        for (Field f : fields) {
                            Excel annotation = f.getAnnotation(Excel.class);
                            if (annotation.type() != Excel.Type.ALL && annotation.type() != Excel.Type.IMPORT || !annotation.name().equals(row.getCell(y).getStringCellValue())) continue;
                            cell.put(y, f.getName());
                            continue block3;
                        }
                    }
                    continue;
                }
                Object obj = entity.newInstance();
                block5: for (int y = 0; y < row.getPhysicalNumberOfCells(); ++y) {
                    for (Integer key : cell.keySet()) {
                        if (y != key) continue;
                        block7: for (Field f : fields) {
                            if (!f.getName().equals(cell.get(key))) continue;
                            Excel annotation = f.getAnnotation(Excel.class);
                            if (!"".equals(annotation.dictType()) && redisUtil != null) {
                                JSONArray vals;
                                Object redis = redisUtil.getByString(annotation.dictType());
                                if (redis == null || (vals = ((JSONObject)redis).getJSONArray("list")) == null || vals.size() <= 0) continue;
                                for (Object j : vals) {
                                    if (j == null || !((JSONObject)j).get("label").equals(row.getCell(y).getStringCellValue())) continue;
                                    reflect.setNormal(f, f.getType(), entity, ((JSONObject)j).get("val"));
                                    continue block7;
                                }
                                continue;
                            }
                            if (!"".equals(annotation.readConverterExp())) {
                                String[] split = annotation.readConverterExp().split(",");
                                if (split.length <= 0) continue;
                                for (String s : split) {
                                    String[] v = s.split("=");
                                    if (v.length <= 0 || !v[1].equals(row.getCell(y).getStringCellValue())) continue;
                                    reflect.setNormal(f, f.getType(), entity, v[0]);
                                    continue block7;
                                }
                                continue;
                            }
                            if (!"".equals(annotation.suffix())) {
                                reflect.setNormal(f, f.getType(), entity, row.getCell(y).getStringCellValue().replace(annotation.suffix(), ""));
                                continue block5;
                            }
                            reflect.setNormal(f, f.getType(), entity, row.getCell(y).getStringCellValue());
                            continue block5;
                        }
                    }
                }
                list.add(obj);
            }
        }
        catch (Exception e) {
            throw new MyRuntimeException(e.getMessage());
        }
        return list;
    }

    private static void download(Workbook workbook, String fileName) throws IOException {
        Context ctx = Context.current();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        workbook.write((OutputStream)os);
        ctx.headerSet("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "utf-8"));
        ctx.contentType("application/octet-stream;charset=UTF-8");
        ctx.headerSet("Pargam", "no-cache");
        ctx.headerSet("Cache-Control", "no-cache");
        ctx.contentLength((long)os.size());
        ctx.headerSet("Content-Length", "" + os.size());
        OutputStream outputStream = ctx.outputStream();
        os.writeTo(outputStream);
        os.close();
        outputStream.flush();
    }

    private static void write(Workbook workbook, String fileName, String path) throws IOException {
        FileOutputStream os = null;
        ExcelUtil.setResponseHeader(fileName);
        File file = new File(path + "/" + fileName);
        os = new FileOutputStream(file);
        workbook.write((OutputStream)os);
        if (os != null) {
            ((OutputStream)os).close();
        }
    }

    private static void setResponseHeader(String fileName) {
        try {
            Context ctx = Context.current();
            fileName = new String(fileName.getBytes(), "UTF-8");
            ctx.contentType("application/octet-stream;charset=UTF-8");
            ctx.headerSet("Pragma", "no-cache");
            ctx.headerSet("Cache-Control", "no-cache");
            ctx.headerSet("Content-Disposition", "attachment;filename=" + fileName);
        }
        catch (UnsupportedEncodingException e) {
            throw new MyRuntimeException(e.getMessage());
        }
    }
}

