/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.core.util;

import cn.ezeyc.core.util.SerializeUtil;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Inject;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Configuration
public class RedisUtil {
    @Inject(value="${e.cache.server}")
    private String server;
    @Inject(value="${e.cache.db}")
    private Integer db;
    @Inject(value="${e.cache.password}")
    private String pwd;
    private Jedis jedis;
    private JedisPool jedisPool;

    public void init() {
        this.initialPool();
    }

    private void initialPool() {
        GenericObjectPoolConfig jedisPoolConfig = new GenericObjectPoolConfig();
        jedisPoolConfig.setMaxTotal(20);
        jedisPoolConfig.setMaxIdle(10);
        jedisPoolConfig.setMaxWaitMillis(10000L);
        jedisPoolConfig.setTestOnBorrow(true);
        jedisPoolConfig.setTestOnReturn(true);
        this.jedisPool = !"".equals(this.pwd) ? new JedisPool("redis://" + this.pwd + "@" + this.server + "/" + this.db) : new JedisPool("redis://" + this.server + "/" + this.db);
    }

    public Jedis getJedis() {
        return this.jedisPool.getResource();
    }

    public String get(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(this.db.intValue());
            String string = jedis.get(key);
            return string;
        }
    }

    public byte[] get(byte[] key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(this.db.intValue());
            byte[] byArray = jedis.get(key);
            return byArray;
        }
    }

    public Object getNormal(Object key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(this.db.intValue());
            Object object = SerializeUtil.unSerialize(jedis.get(SerializeUtil.serialize(key)));
            return object;
        }
    }

    public Object getByString(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(this.db.intValue());
            String s = jedis.get(key);
            if (s != null) {
                Object object = SerializeUtil.unSerializeString(s);
                return object;
            }
            Object var5_7 = null;
            return var5_7;
        }
    }

    public String set(String key, String value) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(this.db.intValue());
            String string = jedis.set(key, value);
            return string;
        }
    }

    public String set(String key, String value, int time) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(this.db.intValue());
            String set = jedis.set(key, value);
            jedis.expire(key, (long)time);
            String string = set;
            return string;
        }
    }

    public String set(String key, Object value, int time) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(this.db.intValue());
            String set = jedis.set(key, String.valueOf(value));
            jedis.expire(key, (long)time);
            String string = set;
            return string;
        }
    }

    public String set(String key, Object value) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String set;
            jedis.select(this.db.intValue());
            String string = set = jedis.set(key, String.valueOf(value));
            return string;
        }
    }

    public String set(Object key, Object value) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(this.db.intValue());
            String string = jedis.set(SerializeUtil.serialize(key), SerializeUtil.serialize(value));
            return string;
        }
    }

    public String setByString(String key, Object value) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(this.db.intValue());
            String string = jedis.set(key, SerializeUtil.serializeString(value));
            return string;
        }
    }

    public String setToObj(String key, Object value, Class c) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(this.db.intValue());
            String string = jedis.set(key, SerializeUtil.serializeString(JSONObject.parseObject((String)JSONObject.toJSONString((Object)value, (JSONWriter.Feature[])new JSONWriter.Feature[0]), (Class)c)));
            return string;
        }
    }

    public String set(byte[] key, byte[] value) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(this.db.intValue());
            String string = jedis.set(key, value);
            return string;
        }
    }

    public Long del(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(this.db.intValue());
            Long l = jedis.del(key);
            return l;
        }
    }

    public void delBySuffix(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(this.db.intValue());
            Set keys = jedis.keys(key + "*");
            for (String s : keys) {
                jedis.del(s);
            }
        }
    }

    public Long lpush(String key, String ... values) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(this.db.intValue());
            Long l = jedis.lpush(key, values);
            return l;
        }
    }

    public String lpop(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(this.db.intValue());
            String string = jedis.lpop(key);
            return string;
        }
    }

    public Long rpush(String key, String ... values) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(this.db.intValue());
            Long l = jedis.rpush(key, values);
            return l;
        }
    }

    public String rpop(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(this.db.intValue());
            String string = jedis.rpop(key);
            return string;
        }
    }

    public Boolean exists(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(this.db.intValue());
            Boolean bl = jedis.exists(key);
            return bl;
        }
    }

    public Boolean exists(Object key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(this.db.intValue());
            Boolean bl = jedis.exists(SerializeUtil.serialize(key));
            return bl;
        }
    }
}

