/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.core.util;

import cn.ezeyc.core.util.ClassUtil;
import fr.opensagres.poi.xwpf.converter.core.ImageManager;
import fr.opensagres.poi.xwpf.converter.core.Options;
import fr.opensagres.poi.xwpf.converter.xhtml.XHTMLConverter;
import fr.opensagres.poi.xwpf.converter.xhtml.XHTMLOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.converter.PicturesManager;
import org.apache.poi.hwpf.converter.WordToHtmlConverter;
import org.apache.poi.hwpf.usermodel.PictureType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.noear.solon.annotation.Inject;
import org.noear.solon.core.handle.UploadedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ToHtml {
    private static final Logger log = LoggerFactory.getLogger(ToHtml.class);
    @Inject(value="${upload.path}")
    private final String uploadPath = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File convert(UploadedFile file) {
        String suffix = file.name.substring(file.name.lastIndexOf("."));
        String newName = UUID.randomUUID().toString();
        File convFile = new File("" + newName + suffix);
        FileOutputStream fos = null;
        try {
            convFile.createNewFile();
            fos = new FileOutputStream(convFile);
            fos.write(ClassUtil.readStream(file.content));
        }
        catch (IOException ex) {
            File file2;
            try {
                log.error("\u4e0a\u4f20\u6587\u4ef6\u51fa\u9519\uff01", (Throwable)ex);
                file2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fos);
            return file2;
        }
        IOUtils.closeQuietly((OutputStream)fos);
        String parentDirectory = convFile.getParent();
        if (!parentDirectory.endsWith("\\")) {
            parentDirectory = parentDirectory + "\\";
        }
        if (file.name.endsWith(".docx")) {
            return this.docxConvert(parentDirectory, convFile, newName);
        }
        if (file.name.endsWith(".doc")) {
            return this.docConvert(parentDirectory, convFile, newName);
        }
        log.error("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u683c\u5f0f\uff01");
        return null;
    }

    private File htmlreplace(String parentDirectory, String filename, String newName) {
        try {
            FileInputStream inputStream = new FileInputStream(new File(parentDirectory + filename + ".html"));
            InputStream inputStrem = ToHtml.readInputStrem(inputStream);
            ToHtml.clearInfoForFile(parentDirectory + filename + ".html");
            byte[] buffer = new byte[inputStrem.available()];
            inputStrem.read(buffer);
            FileOutputStream outStream = new FileOutputStream(new File(parentDirectory + newName + ".html"));
            ((OutputStream)outStream).write(buffer);
            return new File(parentDirectory + newName + ".html");
        }
        catch (FileNotFoundException e) {
            log.error("Html\u8f6c\u6362\u5931\u8d25\uff01", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            log.error("Html\u8f6c\u6362\u5931\u8d25\uff01", (Throwable)e);
            return null;
        }
    }

    private static InputStream readInputStrem(InputStream inputStream) {
        String regEx_special = "width:595.3pt;";
        String regEx_special2 = "white-space:pre-wrap;";
        String replace = "white-space:pre-wrap;word-break:break-all;";
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = -1;
            while ((len = inputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            String content = baos.toString();
            baos.close();
            Pattern compile = Pattern.compile(regEx_special, 2);
            Matcher matcher = compile.matcher(content);
            String replaceAll = matcher.replaceAll("");
            Pattern compile2 = Pattern.compile(regEx_special2, 2);
            Matcher matcher2 = compile2.matcher(replaceAll);
            String replaceAll2 = matcher2.replaceAll(replace);
            InputStream stringStream = ToHtml.getStringStream(replaceAll2);
            return stringStream;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            return null;
        }
    }

    public static InputStream getStringStream(String sInputString) {
        if (sInputString != null && !sInputString.trim().equals("")) {
            try {
                ByteArrayInputStream tInputStringStream = new ByteArrayInputStream(sInputString.getBytes());
                return tInputStringStream;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void clearInfoForFile(String fileName) {
        File file = new File(fileName);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("");
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File docxConvert(String parentDirectory, File file, String newName) {
        try {
            XWPFDocument document = new XWPFDocument((InputStream)new FileInputStream(file));
            XHTMLOptions options = XHTMLOptions.create().setImageManager(new ImageManager(new File(parentDirectory), UUID.randomUUID().toString())).indent(Integer.valueOf(4));
            FileOutputStream out = new FileOutputStream(new File(parentDirectory + newName + ".html"));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
            XHTMLConverter xhtmlConverter = (XHTMLConverter)XHTMLConverter.getInstance();
            xhtmlConverter.convert(document, (Writer)writer, (Options)options);
            File htmlreplace = this.htmlreplace(parentDirectory, newName, newName);
            return htmlreplace;
        }
        catch (IOException ex) {
            log.error("word\u8f6c\u5316\u51fa\u9519\uff01", (Throwable)ex);
            return null;
        }
    }

    private File docConvert(final String parentDirectory, File filename, String newName) {
        try {
            HWPFDocument document = new HWPFDocument((InputStream)new FileInputStream(filename));
            WordToHtmlConverter wordToHtmlConverter = new WordToHtmlConverter(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
            wordToHtmlConverter.setPicturesManager(new PicturesManager(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public String savePicture(byte[] bytes, PictureType pictureType, String s, float v, float v1) {
                    FileOutputStream out;
                    File imageFile;
                    block8: {
                        String imageFilename = parentDirectory + "";
                        String identity = UUID.randomUUID().toString();
                        imageFile = new File(imageFilename, identity + s);
                        imageFile.getParentFile().mkdirs();
                        ByteArrayInputStream in = null;
                        out = null;
                        try {
                            in = new ByteArrayInputStream(bytes);
                            out = new FileOutputStream(imageFile);
                            IOUtils.copy((InputStream)in, (OutputStream)out);
                            if (in == null) break block8;
                        }
                        catch (IOException ex) {
                            block9: {
                                try {
                                    log.error("word\u8f6c\u5316\u51fa\u9519\uff01", (Throwable)ex);
                                    if (in == null) break block9;
                                }
                                catch (Throwable throwable) {
                                    if (in != null) {
                                        IOUtils.closeQuietly((InputStream)in);
                                    }
                                    if (out != null) {
                                        IOUtils.closeQuietly(out);
                                    }
                                    throw throwable;
                                }
                                IOUtils.closeQuietly((InputStream)in);
                            }
                            if (out != null) {
                                IOUtils.closeQuietly((OutputStream)out);
                            }
                        }
                        IOUtils.closeQuietly((InputStream)in);
                    }
                    if (out != null) {
                        IOUtils.closeQuietly((OutputStream)out);
                    }
                    return imageFile.getName();
                }
            });
            wordToHtmlConverter.processDocument((HWPFDocumentCore)document);
            Document htmlDocument = wordToHtmlConverter.getDocument();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DOMSource domSource = new DOMSource(htmlDocument);
            StreamResult streamResult = new StreamResult(out);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("encoding", "GBK");
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("method", "html");
            serializer.transform(domSource, streamResult);
            out.close();
            String result = new String(out.toByteArray());
            FileWriter writer = new FileWriter(parentDirectory + newName + ".html");
            writer.write(result);
            writer.close();
        }
        catch (IOException | ParserConfigurationException | TransformerException ex) {
            log.error("word\u8f6c\u5316\u51fa\u9519\uff01", (Throwable)ex);
        }
        return new File(parentDirectory + newName + ".html");
    }

    public String convertToHtml(UploadedFile file) {
        String wordContent = "";
        File file2 = this.convert(file);
        if (file2 != null) {
            return "\u6587\u4ef6\u8f6c\u6362\u6210\u529f";
        }
        return "\u6587\u4ef6\u8f6c\u6362\u5931\u8d25";
    }

    public static File wordToHtml(File file, String htmlFilePath) {
        String filename = file.getName().substring(file.getName().lastIndexOf(File.separator) + 1);
        String newName = htmlFilePath.substring(htmlFilePath.lastIndexOf(File.separator) + 1, htmlFilePath.lastIndexOf("."));
        File convFile = new File(htmlFilePath);
        String parentDirectory = convFile.getParent();
        if (!parentDirectory.endsWith("\\")) {
            parentDirectory = parentDirectory + "\\";
        }
        if (filename.endsWith(".docx")) {
            return new ToHtml().docxConvert(parentDirectory, file, newName);
        }
        if (filename.endsWith(".doc")) {
            return new ToHtml().docConvert(parentDirectory, file, newName);
        }
        log.error("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u683c\u5f0f\uff01");
        return null;
    }

    public static File xlxsToHtml(File file, String fileName) throws Exception {
        XSSFWorkbook workbook = null;
        FileInputStream is = new FileInputStream(file);
        String htmlUrl = "";
        try {
            String html = "";
            workbook = new XSSFWorkbook((InputStream)is);
            for (int numSheet = 0; numSheet < workbook.getNumberOfSheets(); ++numSheet) {
                Sheet sheet = workbook.getSheetAt(numSheet);
                if (sheet == null) continue;
                html = html + sheet.getSheetName() + "<br><br>";
                int firstRowIndex = sheet.getFirstRowNum();
                int lastRowIndex = sheet.getLastRowNum();
                html = html + "<table border='1' align='left'>";
                Row firstRow = sheet.getRow(firstRowIndex);
                for (int i = firstRow.getFirstCellNum(); i <= firstRow.getLastCellNum(); ++i) {
                    Cell cell = firstRow.getCell(i);
                    String cellValue = ToHtml.getCellValue(cell, true);
                    html = html + "<th>" + cellValue + "</th>";
                }
                for (int rowIndex = firstRowIndex + 1; rowIndex <= lastRowIndex; ++rowIndex) {
                    Row currentRow = sheet.getRow(rowIndex);
                    html = html + "<tr>";
                    if (currentRow != null) {
                        int firstColumnIndex = currentRow.getFirstCellNum();
                        short lastColumnIndex = currentRow.getLastCellNum();
                        for (int columnIndex = firstColumnIndex; columnIndex <= lastColumnIndex; ++columnIndex) {
                            Cell currentCell = currentRow.getCell(columnIndex);
                            String currentCellValue = ToHtml.getCellValue(currentCell, true);
                            html = html + "<td>" + currentCellValue + "</td>";
                        }
                    } else {
                        html = html + " ";
                    }
                    html = html + "</tr>";
                }
                html = html + "</table>";
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                DOMSource domSource = new DOMSource();
                StreamResult streamResult = new StreamResult(outStream);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer serializer = tf.newTransformer();
                serializer.setOutputProperty("encoding", "utf-8");
                serializer.setOutputProperty("indent", "yes");
                serializer.setOutputProperty("method", "html");
                serializer.transform(domSource, streamResult);
                outStream.close();
                File fileHtml = new File(fileName);
                FileUtils.writeStringToFile((File)fileHtml, (String)html, (String)"utf-8");
                return fileHtml;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String getCellValue(Cell cell, boolean treatAsStr) {
        if (cell == null) {
            return "";
        }
        if (treatAsStr) {
            cell.setCellType(CellType.STRING);
        }
        if (cell.getCellType() == CellType.BOOLEAN) {
            return String.valueOf(cell.getBooleanCellValue());
        }
        if (cell.getCellType() == CellType.NUMERIC) {
            return String.valueOf(cell.getNumericCellValue());
        }
        if (cell.getCellType() == CellType.NUMERIC) {
            return String.valueOf(cell.getNumericCellValue());
        }
        return String.valueOf(cell.getStringCellValue());
    }

    public static void main(String[] args) throws Exception {
        long timeMillis = System.currentTimeMillis();
        log.info("\u5f00\u59cb\u8f6c\u6362\uff01");
        String wordFilePath = "/Users/wz/Downloads/\u6587\u6863/\u7efc\u5408\u8c03\u5ea6\u7cfb\u7edf\u524d\u7aef\u4ee3\u7801\u6a21\u5757.xlsx";
        String htmlFilePath = "/Users/wz/Downloads/\u6587\u6863/\u7efc\u5408\u8c03\u5ea6\u7cfb\u7edf\u524d\u7aef\u4ee3\u7801\u6a21\u5757.html";
        File file = ToHtml.xlxsToHtml(new File(wordFilePath), htmlFilePath);
        if (file != null) {
            log.info("\u6587\u4ef6\u5b58\u653e\u8def\u5f84\uff1a{}", (Object)file.getPath());
            log.info("\u8f6c\u6362\u7ed3\u675f\uff01\u7528\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - timeMillis));
            return;
        }
        log.error("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25\uff01");
    }
}

