/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.core.codegenerator;

import cn.ezeyc.core.codegenerator.CodeCreate;
import cn.ezeyc.core.codegenerator.Column;
import cn.ezeyc.core.codegenerator.FreeMarkerTemplateUtils;
import cn.ezeyc.core.config.Const;
import cn.ezeyc.core.pojo.MyRuntimeException;
import cn.ezeyc.core.util.Util;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.annotation.Configuration;

@Configuration
public class CodeGenerator {
    List<Column> columnClassList = new ArrayList<Column>();

    public void generate(CodeCreate codeCreate, Boolean model, Boolean dao, Boolean service, Boolean control2, Boolean uiList, Boolean uiEdit, Boolean treeList) {
        try {
            boolean isList;
            Connection connection = codeCreate.getDataSource().getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getColumns(connection.getCatalog(), "%", codeCreate.getTableName(), "%");
            codeCreate.setResultSet(resultSet);
            if (model.booleanValue()) {
                this.generateModelFile(codeCreate);
            }
            if (dao.booleanValue()) {
                this.generateDaoFile(codeCreate);
            }
            if (service.booleanValue()) {
                this.generateServiceFile(codeCreate);
                this.generateServiceImplFile(codeCreate);
            }
            if (control2.booleanValue()) {
                this.generateControlFile(codeCreate);
            }
            boolean bl = isList = uiList != false || uiEdit != false;
            if (treeList.booleanValue() && isList) {
                throw new MyRuntimeException("treeList\u8ddfuiList\u6216uiEdit\u4e0d\u53ef\u540c\u65f6\u4e3atrue,\u6811\u72b6\u9875\u9762\uff0c\u8ddf\u666e\u901a\u9875\u4e0d\u53ef\u540c\u65f6\u751f\u6210");
            }
            if (uiList.booleanValue()) {
                this.generateListFile(codeCreate);
            }
            if (uiEdit.booleanValue()) {
                this.generateEditFile(codeCreate);
            }
            if (treeList.booleanValue()) {
                this.generateTreeFile(codeCreate);
            }
        }
        catch (Exception e) {
            throw new MyRuntimeException(e.getMessage());
        }
    }

    private void generateTreeFile(CodeCreate codeCreate) throws Exception {
        String service = codeCreate.getArtifactId().replace("e-", "");
        String path = codeCreate.getRootUIPath() + File.separator + "pages/" + service + Const.slanting + Util.toLowerCaseFirstOne(Util.lineToHump(codeCreate.getTableName()));
        codeCreate.setTemplate("tree.ftl");
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        f = new File(f.getPath() + "/list.vue");
        HashMap<String, Object> dataMap = new HashMap<String, Object>(9);
        dataMap.put("column", this.columnClassList);
        dataMap.put("service", service);
        this.generateFileByTemplate(codeCreate, f, dataMap);
    }

    private void generateEditFile(CodeCreate codeCreate) throws Exception {
        String service = codeCreate.getArtifactId().replace("e-", "");
        String path = codeCreate.getRootUIPath() + File.separator + "pages/" + service + Const.slanting + Util.toLowerCaseFirstOne(Util.lineToHump(codeCreate.getTableName()));
        codeCreate.setTemplate("edit.ftl");
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        f = new File(f.getPath() + "/edit.vue");
        HashMap<String, Object> dataMap = new HashMap<String, Object>(9);
        dataMap.put("column", this.columnClassList);
        dataMap.put("service", service);
        this.generateFileByTemplate(codeCreate, f, dataMap);
    }

    private void generateListFile(CodeCreate codeCreate) throws Exception {
        String service = codeCreate.getArtifactId().replace("e-", "");
        String path = codeCreate.getRootUIPath() + File.separator + "pages/" + service + Const.slanting + Util.toLowerCaseFirstOne(Util.lineToHump(codeCreate.getTableName()));
        codeCreate.setTemplate("list.ftl");
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        f = new File(f.getPath() + "/list.vue");
        HashMap<String, Object> dataMap = new HashMap<String, Object>(9);
        dataMap.put("column", this.columnClassList);
        dataMap.put("service", service);
        this.generateFileByTemplate(codeCreate, f, dataMap);
    }

    private void generateModelFile(CodeCreate codeCreate) throws Exception {
        String path = codeCreate.getRootPath() + Const.package_model + Const.slanting + Util.toUpperCaseFirstOne(Util.lineToHump(codeCreate.getTableName())) + Const.suffix_java;
        File f = new File(path);
        this.columnClassList = new ArrayList<Column>();
        ResultSet resultSet = codeCreate.getResultSet();
        while (resultSet.next()) {
            if ("id".equals(resultSet.getString("COLUMN_NAME")) || "create_user".equals(resultSet.getString("COLUMN_NAME")) || "update_user".equals(resultSet.getString("COLUMN_NAME")) || "create_date".equals(resultSet.getString("COLUMN_NAME")) || "update_date".equals(resultSet.getString("COLUMN_NAME")) || "data_code".equals(resultSet.getString("COLUMN_NAME")) || "remove".equals(resultSet.getString("COLUMN_NAME"))) continue;
            Column columnClass = new Column();
            columnClass.setColumnName(resultSet.getString("COLUMN_NAME"));
            columnClass.setColumnType(resultSet.getString("TYPE_NAME"));
            columnClass.setChangeColumnName(Util.lineToHump(resultSet.getString("COLUMN_NAME")));
            columnClass.setColumnComment(resultSet.getString("REMARKS"));
            this.columnClassList.add(columnClass);
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>(11);
        dataMap.put("column", this.columnClassList);
        codeCreate.setTemplate("model.ftl");
        this.generateFileByTemplate(codeCreate, f, dataMap);
    }

    private void generateDaoFile(CodeCreate codeCreate) throws Exception {
        String path = codeCreate.getRootPath() + Const.package_dao + Const.slanting + Util.toUpperCaseFirstOne(Util.lineToHump(codeCreate.getTableName())) + Const.end_with_Dao + Const.suffix_java;
        codeCreate.setTemplate("dao.ftl");
        File f = new File(path);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(9);
        this.generateFileByTemplate(codeCreate, f, dataMap);
    }

    private void generateServiceFile(CodeCreate codeCreate) throws Exception {
        String path = codeCreate.getRootPath() + Const.package_service + Const.slanting + Util.toUpperCaseFirstOne(Util.lineToHump(codeCreate.getTableName())) + Const.end_with_service + Const.suffix_java;
        codeCreate.setTemplate("service.ftl");
        File f = new File(path);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(9);
        this.generateFileByTemplate(codeCreate, f, dataMap);
    }

    private void generateServiceImplFile(CodeCreate codeCreate) throws Exception {
        String path = codeCreate.getRootPath() + Const.package_service_impl + Const.slanting + Util.toUpperCaseFirstOne(Util.lineToHump(codeCreate.getTableName())) + Const.end_with_service_impl + Const.suffix_java;
        codeCreate.setTemplate("impl.ftl");
        File f = new File(path);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(9);
        this.generateFileByTemplate(codeCreate, f, dataMap);
    }

    private void generateControlFile(CodeCreate codeCreate) throws Exception {
        String path = codeCreate.getRootPath() + Const.package_control + Const.slanting + Util.toUpperCaseFirstOne(Util.lineToHump(codeCreate.getTableName())) + Const.end_with_control + Const.suffix_java;
        codeCreate.setTemplate("control.ftl");
        File f = new File(path);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(11);
        dataMap.put("column", this.columnClassList);
        this.generateFileByTemplate(codeCreate, f, dataMap);
    }

    private void generateFileByTemplate(CodeCreate codeCreate, File file, Map<String, Object> dataMap) throws Exception {
        File f;
        Template template = FreeMarkerTemplateUtils.getTemplate(codeCreate.getTemplate());
        int i = file.getPath().lastIndexOf("/");
        if (i == -1) {
            i = file.getPath().lastIndexOf("\\");
        }
        if (!(f = new File(file.getPath().substring(0, i))).exists()) {
            f.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(file);
        dataMap.put("table_name", codeCreate.getTableName());
        dataMap.put("tableName", Util.toUpperCaseFirstOne(Util.lineToHump(codeCreate.getTableName())));
        dataMap.put("url", Util.lineToHump(codeCreate.getTableName()));
        if (codeCreate.getAuthor() != null && !"".equals(codeCreate.getAuthor())) {
            dataMap.put("author", codeCreate.getAuthor());
        } else {
            dataMap.put("author", Const.AUTHOR);
        }
        dataMap.put("date", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        dataMap.put("package", codeCreate.getPackagePath());
        if (codeCreate.getRemark() != null && !"".equals(codeCreate.getRemark())) {
            dataMap.put("remark", codeCreate.getRemark());
        } else {
            dataMap.put("remark", "\u6682\u65e0");
        }
        if (codeCreate.getArtifactName() != null && !"".equals(codeCreate.getArtifactName())) {
            dataMap.put("name", codeCreate.getArtifactName());
        } else {
            dataMap.put("name", "\u672a\u5f52\u5c5e");
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8), 10240);
        template.process(dataMap, (Writer)out);
    }
}

