/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.core.doc;

import cn.ezeyc.core.doc.DocConfig;
import cn.torna.sdk.client.OpenClient;
import cn.torna.sdk.param.EnumInfoParam;
import cn.torna.sdk.param.EnumItemParam;
import cn.torna.sdk.request.BaseRequest;
import cn.torna.sdk.request.EnumBatchPushRequest;
import cn.torna.sdk.response.EnumPushResponse;
import com.alibaba.fastjson2.JSON;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class Directory {
    private static DocConfig config;
    private static OpenClient client;
    HikariDataSource dataSource = new HikariDataSource();

    public void create() {
        config = this.getJson();
        this.dataSource.setDriverClassName("com.mysql.cj.jdbc.Driver");
        this.dataSource.setJdbcUrl(config.getSqlUrl());
        this.dataSource.setUsername(config.getUser());
        this.dataSource.setPassword(config.getPwd());
        client = new OpenClient(config.getOpenUrl());
        try {
            this.testEnumPush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void testEnumPush() throws SQLException {
        EnumBatchPushRequest request = new EnumBatchPushRequest(config.getAppToken());
        request.setEnums(this.getEnumInfos());
        EnumPushResponse response = (EnumPushResponse)client.execute((BaseRequest)request);
        if (response.isSuccess()) {
            System.out.println("=================\u8bf7\u6c42\u6210\u529f=====================");
        } else {
            System.out.println("errorCode:" + response.getCode() + ",errorMsg:" + response.getMsg());
        }
    }

    private DocConfig getJson() {
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("doc.json");
        String jsontext = null;
        try {
            jsontext = IOUtils.toString((InputStream)resourceAsStream, (String)"utf8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (DocConfig)JSON.parseObject((String)jsontext, DocConfig.class);
    }

    private List<EnumInfoParam> getEnumInfos() throws SQLException {
        ArrayList<EnumInfoParam> list = new ArrayList<EnumInfoParam>();
        Connection connection = this.dataSource.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement("select d.`label`as name,d.code,v.`label`,v.val FROM sys_direct_value v LEFT JOIN sys_direct d on v.pid=d.id ");
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<EnumItemParam> itemParams = null;
        EnumInfoParam enumInfoParam = null;
        String name = "";
        while (resultSet.next()) {
            if (!name.equals(resultSet.getString("name"))) {
                enumInfoParam = new EnumInfoParam();
                itemParams = new ArrayList<EnumItemParam>();
                enumInfoParam.setName(resultSet.getString("name"));
                enumInfoParam.setDescription(resultSet.getString("code"));
            }
            EnumItemParam itemParam = new EnumItemParam();
            itemParam.setValue(resultSet.getString("val"));
            itemParam.setDescription(resultSet.getString("label"));
            itemParam.setName(resultSet.getString("label"));
            itemParam.setType(Directory.getType(resultSet.getString("val")));
            itemParams.add(itemParam);
            if (!name.equals(resultSet.getString("name"))) {
                enumInfoParam.setItems(itemParams);
                list.add(enumInfoParam);
            }
            name = resultSet.getString("name");
        }
        connection.close();
        return list;
    }

    public static String getType(String o) {
        if ("true".equals(o) || "false".equals(o)) {
            return "Boolean";
        }
        if (Directory.isNumeric(o)) {
            return "Number";
        }
        return "String";
    }

    public static boolean isNumeric(String str) {
        int i = str.length();
        while (--i >= 0) {
            char chr = str.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            return false;
        }
        return true;
    }

    static {
        client = null;
    }
}

