/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.core.doc;

import cn.ezeyc.core.doc.Directory;
import cn.ezeyc.core.doc.DocConfig;
import cn.ezeyc.core.enums.ResultEnum;
import cn.ezeyc.core.pojo.ResultBody;
import cn.ezeyc.core.util.StringUtil;
import cn.torna.sdk.client.OpenClient;
import cn.torna.sdk.param.DebugEnv;
import cn.torna.sdk.param.DocItem;
import cn.torna.sdk.param.DocParamCode;
import cn.torna.sdk.param.DocParamHeader;
import cn.torna.sdk.param.DocParamReq;
import cn.torna.sdk.param.DocParamResp;
import cn.torna.sdk.param.EnumInfoParam;
import cn.torna.sdk.param.EnumItemParam;
import cn.torna.sdk.request.BaseRequest;
import cn.torna.sdk.request.DocPushRequest;
import cn.torna.sdk.response.DocPushResponse;
import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.solon.plugins.pagination.Page;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.directorywalker.DirectoryScanner;
import com.thoughtworks.qdox.directorywalker.Filter;
import com.thoughtworks.qdox.directorywalker.SuffixFilter;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaParameterizedType;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import com.thoughtworks.qdox.model.impl.DefaultJavaParameterizedType;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class Doc {
    private static DocConfig config;
    private static OpenClient client;
    private static String root;
    JavaProjectBuilder builder = new JavaProjectBuilder();
    private static List<DocItem> list;
    private List<JavaClass> models = new ArrayList<JavaClass>();
    private String author = "none";
    HikariDataSource dataSource = new HikariDataSource();
    private int index = 100;

    public void create() {
        config = this.getJson();
        this.dataSource.setDriverClassName("com.mysql.cj.jdbc.Driver");
        this.dataSource.setJdbcUrl(config.getSqlUrl());
        this.dataSource.setUsername(config.getUser());
        this.dataSource.setPassword(config.getPwd());
        client = new OpenClient(config.getOpenUrl());
        root = System.getProperty("user.dir") + File.separator + config.getModelPath() + File.separator + "src" + File.separator + "main" + File.separator + "java";
        try {
            this.testDocPush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void testDocPush() throws ClassNotFoundException, SQLException {
        DocPushRequest request = new DocPushRequest(config.getAppToken());
        this.loadJavaSource();
        DebugEnv debugEnv = new DebugEnv(config.getDebugEnvName(), config.getDebugEnvUrl());
        request.setApis(list);
        request.setDebugEnvs(Arrays.asList(debugEnv));
        request.setAuthor(this.author);
        request.setIsReplace(Byte.valueOf((byte)1));
        DocPushResponse response = (DocPushResponse)client.execute((BaseRequest)request);
        if (response.isSuccess()) {
            System.out.println("=================\u8bf7\u6c42\u6210\u529f=====================");
        } else {
            System.out.println("errorCode:" + response.getCode() + ",errorMsg:" + response.getMsg());
        }
    }

    private DocConfig getJson() {
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("doc.json");
        String jsontext = null;
        try {
            jsontext = IOUtils.toString((InputStream)resourceAsStream, (String)"utf8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (DocConfig)JSON.parseObject((String)jsontext, DocConfig.class);
    }

    private void loadJavaSource() throws ClassNotFoundException, SQLException {
        List<String> packages = config.getPackages();
        if (packages != null && packages.size() > 0) {
            for (String path : packages) {
                DirectoryScanner scanner = new DirectoryScanner(new File(root + File.separator + path.replaceAll("\\.", "/")));
                scanner.addFilter((Filter)new SuffixFilter(".java"));
                scanner.scan(currentFile -> {
                    try {
                        this.builder.addSource(currentFile);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
                Collection classes = this.builder.getClasses();
                for (JavaClass aClass : classes) {
                    List annotations = aClass.getAnnotations();
                    for (JavaAnnotation an : annotations) {
                        if ("org.noear.solon.annotation.Controller".equals(an.getType().getFullyQualifiedName()) || "ezeyc.core.annotation.control".equals(an.getType().getFullyQualifiedName())) {
                            this.getDoc(aClass);
                            continue;
                        }
                        if (!"com.baomidou.mybatisplus.annotation.TableName".equals(an.getType().getFullyQualifiedName()) && !"ezeyc.core.annotation.body".equals(an.getType().getFullyQualifiedName())) continue;
                        this.models.add(aClass);
                    }
                }
            }
        }
    }

    private void getDoc(JavaClass aClass) throws ClassNotFoundException, SQLException {
        DocItem folder = new DocItem();
        folder.setIsFolder(Byte.valueOf((byte)1));
        if ("".equals(aClass.getComment())) {
            folder.setName("default");
        } else {
            folder.setName(aClass.getComment());
        }
        folder.setIsShow(Byte.valueOf((byte)1));
        folder.setOrderIndex(Integer.valueOf(this.index));
        ++this.index;
        List tags = aClass.getTags();
        if (tags.size() > 0) {
            for (DocletTag d : tags) {
                if ("author".equals(d.getName())) {
                    this.author = d.getValue();
                    folder.setAuthor(d.getValue());
                    continue;
                }
                if (!"index".equals(d.getName())) continue;
                folder.setOrderIndex(Integer.valueOf(d.getValue()));
            }
        }
        folder.setUrl(StringUtil.toLowerCaseFirstOne(aClass.getSimpleName()).replaceAll("Control", ""));
        ArrayList<DocItem> items = new ArrayList<DocItem>(8);
        List methods = aClass.getMethods();
        if (methods.size() > 0) {
            for (int i = 0; i < methods.size(); ++i) {
                DocItem docItem = this.buildDocItem((JavaMethod)methods.get(i), folder);
                if (docItem == null) continue;
                docItem.setOrderIndex(Integer.valueOf(i));
                items.add(docItem);
            }
        }
        folder.setItems(items);
        list.add(folder);
    }

    private DocItem buildDocItem(JavaMethod method, DocItem folder) throws ClassNotFoundException, SQLException {
        DocItem item = new DocItem();
        item.setAuthor(folder.getAuthor());
        item.setName(method.getComment());
        item.setDescription("\u63cf\u8ff0\u4fe1\u606f");
        item.setUrl("/" + folder.getUrl() + "/" + method.getName());
        item.setHttpMethod("POST");
        List annotations = method.getAnnotations();
        for (JavaAnnotation an : annotations) {
            if (!"org.noear.solon.annotation.Get".equals(an.getType().getFullyQualifiedName())) continue;
            item.setHttpMethod("GET");
        }
        List tags = method.getTags();
        item.setIsShow(Byte.valueOf((byte)1));
        item.setContentType("application/json");
        List parameters = method.getParameters();
        for (JavaParameter p : parameters) {
            if (!p.getType().getFullyQualifiedName().equals("org.noear.solon.core.handle.UploadedFile")) continue;
            item.setContentType("multipart/form-data");
            break;
        }
        boolean noApi = false;
        ArrayList<DocParamReq> paramReqs = new ArrayList<DocParamReq>();
        if (tags != null && tags.size() > 0) {
            for (DocletTag tag : tags) {
                DocParamReq paramReq;
                JavaParameter param;
                String[] val;
                if ("noApi".equals(tag.getName())) {
                    return null;
                }
                if ("index".equals(tag.getName())) {
                    folder.setOrderIndex(Integer.valueOf(tag.getValue()));
                }
                if ("show".equals(tag.getName()) && "false".equals(tag.getValue())) {
                    item.setIsShow(Byte.valueOf((byte)0));
                }
                if ("ContentType".equals(tag.getName()) && !"".equals(tag.getValue())) {
                    item.setContentType(tag.getValue());
                }
                if ("description".equals(tag.getName()) && !"".equals(tag.getValue())) {
                    item.setDescription(tag.getValue());
                }
                if ("author".equals(tag.getName()) && !"".equals(tag.getValue())) {
                    folder.setAuthor(tag.getValue());
                }
                if ("List".equals(tag.getName()) && !"".equals(tag.getValue())) {
                    val = StringUtil.delEmpty(tag.getValue().split(" "));
                    param = method.getParameterByName(val[0]);
                    paramReq = new DocParamReq();
                    paramReq.setType(param.getValue());
                    paramReq.setExample("[\u5bf9\u8c61\u503c,\u5bf9\u8c61\u503c1]");
                    paramReq.setName(val[2]);
                    paramReq.setDescription(val[2]);
                    paramReq.setRequired(Byte.valueOf((byte)1));
                    paramReq.setChildren(this.setList(method, parameters, item, tags, val[0]));
                    paramReqs.add(paramReq);
                }
                if (!"args".equals(tag.getName()) || "".equals(tag.getValue())) continue;
                val = StringUtil.delEmpty(tag.getValue().split(" "));
                if (val.length < 3) {
                    throw new RuntimeException("\u8bf7\u6c42" + item.getUrl() + "\u53c2\u6570" + val[0] + "\u63cf\u8ff0\u5185\u5bb9");
                }
                param = method.getParameterByName(val[0]);
                paramReq = new DocParamReq();
                paramReq.setName(val[0]);
                if (val.length >= 2 && !val[1].equals("\u5fc5\u9009") && !val[1].equals("\u53ef\u9009")) {
                    throw new RuntimeException("\u8bf7\u6c42" + item.getUrl() + "\u53c2\u6570" + val[0] + "\u7f3a\u5c11\u662f\u5426\u5fc5\u9009");
                }
                if (val[1].equals("\u5fc5\u9009")) {
                    paramReq.setRequired(Byte.valueOf((byte)1));
                } else {
                    paramReq.setRequired(Byte.valueOf((byte)0));
                }
                paramReq.setDescription(val[2]);
                if (val.length >= 4) {
                    paramReq.setExample(val[3]);
                }
                if (param != null) {
                    paramReq.setType(param.getValue());
                    if ("String".equals(param.getValue()) && val.length >= 5 && val[4] != "-1") {
                        paramReq.setMaxLength(val[4]);
                    }
                    paramReqs.add(paramReq);
                    continue;
                }
                if (parameters == null || parameters.size() <= 0) continue;
                for (JavaParameter p : parameters) {
                    if (Doc.isBase(p.getValue())) continue;
                    paramReqs.addAll(this.setModels(Class.forName(p.getFullyQualifiedName()), item, tags, tag.getName()));
                }
            }
        }
        item.setRequestParams(paramReqs);
        item.setHeaderParams(this.setHeader());
        item.setResponseParams(this.setResponse(method));
        item.setErrorCodeParams(this.setError());
        return item;
    }

    private List<DocParamHeader> setHeader() {
        ArrayList<DocParamHeader> headers = new ArrayList<DocParamHeader>();
        DocParamHeader header = new DocParamHeader();
        header.setName("token");
        header.setRequired(Byte.valueOf((byte)1));
        header.setDescription("\u8bf7\u6c42token");
        header.setExample("Ag_tgRYK7t71mc2US_NcRHiVNPQctbyD3Y__");
        headers.add(header);
        header = new DocParamHeader();
        header.setName("SA_ID_TOKEN");
        header.setRequired(Byte.valueOf((byte)0));
        header.setDescription("\u7f51\u5173token");
        header.setExample("Ag_tgRYK7t71mc2US_NcRHiVNPQctbyD3Y__");
        headers.add(header);
        return headers;
    }

    private List<DocParamResp> setResponse(JavaMethod method) throws ClassNotFoundException, SQLException {
        ArrayList<DocParamResp> respList = new ArrayList<DocParamResp>();
        if (method.getReturnType() != null) {
            if (Doc.isBase(method.getReturnType().getValue())) {
                DocParamResp resp = new DocParamResp();
                resp.setType(method.getReturnType().getValue());
                resp.setDescription(method.getReturnType().getValue());
                resp.setExample("");
                respList.add(resp);
            } else if (!"void".equals(method.getReturnType().getValue())) {
                Class<?> aClass = Class.forName(method.getReturnType().getFullyQualifiedName());
                Field[] declaredFields = aClass.getDeclaredFields();
                DocParamResp resp = null;
                if (aClass == ResultBody.class) {
                    for (Field f : declaredFields) {
                        resp = new DocParamResp();
                        resp.setName(f.getName());
                        resp.setType(f.getType().getSimpleName());
                        if ("code".equals(f.getName())) {
                            resp.setDescription("\u72b6\u6001\u7801");
                            resp.setExample("200");
                        } else if ("message".equals(f.getName())) {
                            resp.setDescription("\u8fd4\u56de\u6d88\u606f");
                            resp.setExample("\u6210\u529f");
                        } else if ("extra".equals(f.getName())) {
                            resp.setDescription("\u9644\u52a0\u6570\u636e");
                        } else if ("timestamp".equals(f.getName())) {
                            resp.setDescription("\u670d\u52a1\u5668\u65f6\u95f4");
                            resp.setExample("1212193992");
                        } else if ("data".equals(f.getName())) {
                            if (method.getReturnType().getGenericFullyQualifiedName().contains(Page.class.getName())) {
                                Class<?> page = Class.forName(Page.class.getName());
                                ArrayList<DocParamResp> d = new ArrayList<DocParamResp>();
                                for (Field pf : page.getDeclaredFields()) {
                                    DocParamResp r = new DocParamResp();
                                    r.setName(pf.getName());
                                    r.setType(pf.getType().getSimpleName());
                                    if ("total".equals(pf.getName())) {
                                        r.setDescription("\u603b\u6570");
                                        d.add(r);
                                        continue;
                                    }
                                    if ("size".equals(pf.getName())) {
                                        r.setDescription("\u6bcf\u9875\u6570");
                                        d.add(r);
                                        continue;
                                    }
                                    if ("current".equals(pf.getName())) {
                                        r.setDescription("\u5f53\u524d\u9875");
                                        d.add(r);
                                        continue;
                                    }
                                    if (!"records".equals(pf.getName())) continue;
                                    JavaType javaType = (JavaType)((JavaParameterizedType)method.getReturnType()).getActualTypeArguments().get(0);
                                    JavaType javaType1 = (JavaType)((DefaultJavaParameterizedType)javaType).getActualTypeArguments().get(0);
                                    r.setChildren(this.setModelP(javaType1.getFullyQualifiedName()));
                                    d.add(r);
                                }
                                resp.setChildren(d);
                            } else if (method.getReturnType().getGenericFullyQualifiedName().contains(List.class.getName())) {
                                JavaType javaType;
                                List alls;
                                resp.setType("List");
                                all = ((JavaParameterizedType)method.getReturnType()).getActualTypeArguments();
                                if (all.size() > 0 && (alls = ((DefaultJavaParameterizedType)(javaType = (JavaType)all.get(0))).getActualTypeArguments()).size() > 0) {
                                    resp.setChildren(this.setModelP(((JavaType)alls.get(0)).getFullyQualifiedName()));
                                }
                            } else {
                                all = ((JavaParameterizedType)method.getReturnType()).getActualTypeArguments();
                                if (all.size() > 0) {
                                    resp.setType(((JavaType)all.get(0)).getValue());
                                    resp.setChildren(this.setModelP(((JavaType)all.get(0)).getFullyQualifiedName()));
                                }
                            }
                        }
                        respList.add(resp);
                    }
                } else {
                    respList.addAll(this.setModelP(aClass.getName()));
                }
            }
        }
        return respList;
    }

    private List<DocParamCode> setError() {
        ArrayList<DocParamCode> paramCodes = new ArrayList<DocParamCode>();
        DocParamCode code = null;
        for (int x = 0; x < ResultEnum.values().length; ++x) {
            code = new DocParamCode();
            code.setCode(String.valueOf(ResultEnum.values()[x].getCode()));
            code.setMsg(ResultEnum.values()[x].getMessage());
            code.setSolution(ResultEnum.values()[x].getMessage());
            paramCodes.add(code);
        }
        return paramCodes;
    }

    private List<DocParamResp> setModelP(String name) throws SQLException {
        ArrayList<DocParamResp> reqs = new ArrayList<DocParamResp>();
        for (JavaClass javaClass : this.models) {
            if (!name.equals(javaClass.getFullyQualifiedName())) continue;
            List fields = javaClass.getFields();
            for (JavaField field : fields) {
                DocParamResp r = new DocParamResp();
                r.setName(field.getName());
                r.setDescription(field.getComment());
                r.setType(field.getType().getSimpleName());
                List annotations = field.getAnnotations();
                for (JavaAnnotation j : annotations) {
                    if (!"ezeyc.core.annotation.direct".equals(j.getType().getFullyQualifiedName())) continue;
                    AnnotationValue value = j.getProperty("value");
                    r.setEnumInfo(this.setEnum(value));
                    break;
                }
                if (!Doc.isBase(field.getType().getSimpleName())) {
                    if ("List".equals(field.getType().getSimpleName())) {
                        List all = ((JavaParameterizedType)field.getType()).getActualTypeArguments();
                        if (all.size() > 0 && !Doc.isBase(((JavaType)all.get(0)).getValue())) {
                            r.setChildren(this.setModelP(((JavaType)all.get(0)).getFullyQualifiedName()));
                        }
                    } else {
                        r.setChildren(this.setModelP(field.getType().getFullyQualifiedName()));
                    }
                }
                reqs.add(r);
            }
            if (!"ezeyc.core.pojo.mybatis.ModelBase".equals(javaClass.getSuperClass().getFullyQualifiedName())) break;
            reqs.addAll(this.parentModels());
            break;
        }
        return reqs;
    }

    private EnumInfoParam setEnum(AnnotationValue name) throws SQLException {
        EnumInfoParam enumInfoParam = new EnumInfoParam();
        if (name != null) {
            Connection connection = this.dataSource.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("select d.`label`as name,d.code,v.`label`,v.val FROM sys_direct_value v LEFT JOIN sys_direct d on v.pid=d.id WHERE d.code=" + name);
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<EnumItemParam> list = new ArrayList<EnumItemParam>();
            while (resultSet.next()) {
                enumInfoParam.setName(resultSet.getString("name"));
                enumInfoParam.setDescription(resultSet.getString("code"));
                EnumItemParam itemParam = new EnumItemParam();
                itemParam.setValue(resultSet.getString("val"));
                itemParam.setType(Directory.getType(resultSet.getString("val")));
                itemParam.setName(resultSet.getString("label"));
                itemParam.setDescription(resultSet.getString("label"));
                list.add(itemParam);
            }
            enumInfoParam.setItems(list);
            connection.close();
        }
        return enumInfoParam;
    }

    private List<DocParamResp> parentModels() {
        ArrayList<DocParamResp> reqs = new ArrayList<DocParamResp>();
        DocParamResp r = new DocParamResp();
        r.setName("id");
        r.setDescription("\u4e3b\u952e");
        r.setType("Long");
        reqs.add(r);
        r = new DocParamResp();
        r.setName("createUser");
        r.setDescription("\u521b\u5efa\u4eba");
        r.setType("Long");
        reqs.add(r);
        r = new DocParamResp();
        r.setName("createDate");
        r.setDescription("\u521b\u5efa\u65f6\u95f4");
        r.setType("LocalDateTime");
        reqs.add(r);
        r = new DocParamResp();
        r.setName("updateUser");
        r.setDescription("\u66f4\u65b0\u4eba");
        r.setType("Long");
        reqs.add(r);
        r = new DocParamResp();
        r.setName("updateDate");
        r.setDescription("\u66f4\u65b0\u65f6\u95f4");
        r.setType("LocalDateTime");
        reqs.add(r);
        return reqs;
    }

    private List<DocParamReq> setList(JavaMethod method, List<JavaParameter> parameters, DocItem item, List<DocletTag> tags, String name) throws ClassNotFoundException {
        ArrayList<DocParamReq> reqs = new ArrayList<DocParamReq>();
        for (DocletTag tag : tags) {
            if (!name.equals(tag.getName()) || "".equals(tag.getValue())) continue;
            String[] val = StringUtil.delEmpty(tag.getValue().split(" "));
            if (val.length < 3) {
                throw new RuntimeException("\u8bf7\u6c42" + item.getUrl() + "\u53c2\u6570" + val[0] + "\u63cf\u8ff0\u5185\u5bb9");
            }
            for (JavaParameter p : parameters) {
                Field[] fields;
                List all = ((JavaParameterizedType)p.getType()).getActualTypeArguments();
                if (all.size() <= 0 || Doc.isBase(((JavaType)all.get(0)).getValue())) continue;
                for (Field f : fields = Doc.getAllFields(Class.forName(((JavaType)all.get(0)).getFullyQualifiedName()))) {
                    if (!val[0].equals(f.getName())) continue;
                    DocParamReq paramReq = new DocParamReq();
                    paramReq.setName(val[0]);
                    if (val.length >= 2 && !val[1].equals("\u5fc5\u9009") && !val[1].equals("\u53ef\u9009")) {
                        throw new RuntimeException("\u8bf7\u6c42" + item.getUrl() + "\u53c2\u6570" + val[0] + "\u7f3a\u5c11\u662f\u5426\u5fc5\u9009");
                    }
                    if (val[1].equals("\u5fc5\u9009")) {
                        paramReq.setRequired(Byte.valueOf((byte)1));
                    } else {
                        paramReq.setRequired(Byte.valueOf((byte)0));
                    }
                    paramReq.setDescription(val[2]);
                    if (val.length >= 4) {
                        paramReq.setExample(val[3]);
                    }
                    if (Doc.isBase(f.getType().getSimpleName())) {
                        paramReq.setType(f.getType().getSimpleName());
                        if ("String".equals(f.getType().getSimpleName()) && val.length >= 5 && val[4] != "-1") {
                            paramReq.setMaxLength(val[4]);
                        }
                        reqs.add(paramReq);
                        continue;
                    }
                    reqs.addAll(this.setModels(Class.forName(f.getType().getName()), item, tags, tag.getName()));
                }
            }
        }
        return reqs;
    }

    private List<DocParamReq> setModels(Class aClass, DocItem item, List<DocletTag> tags, String tag) throws ClassNotFoundException {
        ArrayList<DocParamReq> reqs = new ArrayList<DocParamReq>();
        Field[] fields = Doc.getAllFields(aClass);
        block0: for (DocletTag t : tags) {
            if (!tag.equals(t.getName())) continue;
            for (Field f : fields) {
                String[] val = StringUtil.delEmpty(t.getValue().split(" "));
                if (val.length < 3) {
                    throw new RuntimeException("\u8bf7\u6c42" + item.getUrl() + "\u53c2\u6570" + val[0] + "\u63cf\u8ff0\u5185\u5bb9");
                }
                if (!val[0].equals(f.getName())) continue;
                DocParamReq paramReq = new DocParamReq();
                paramReq.setName(val[0]);
                if (val.length >= 2 && !val[1].equals("\u5fc5\u9009") && !val[1].equals("\u53ef\u9009")) {
                    throw new RuntimeException("\u8bf7\u6c42" + item.getUrl() + "\u53c2\u6570" + val[0] + "\u7f3a\u5c11\u662f\u5426\u5fc5\u9009");
                }
                if (val[1].equals("\u5fc5\u9009")) {
                    paramReq.setRequired(Byte.valueOf((byte)1));
                } else {
                    paramReq.setRequired(Byte.valueOf((byte)0));
                }
                paramReq.setDescription(val[2]);
                if (val.length >= 4) {
                    paramReq.setExample(val[3]);
                }
                if (f.getType() == List.class && f.getGenericType() != null) {
                    if (f.getGenericType() instanceof ParameterizedType) {
                        ParameterizedType pt = (ParameterizedType)f.getGenericType();
                        Class argument = (Class)pt.getActualTypeArguments()[0];
                        paramReq.setType(f.getType().getSimpleName());
                        if (!Doc.isBase(argument.getSimpleName())) {
                            paramReq.setExample("");
                            paramReq.setChildren(this.setModels(argument, item, tags, val[3]));
                        }
                    }
                } else if (!Doc.isBase(f.getType().getSimpleName())) {
                    paramReq.setExample("");
                    paramReq.setChildren(this.setModels(Class.forName(f.getType().getName()), item, tags, val[3]));
                } else {
                    paramReq.setType(f.getType().getSimpleName());
                    if ("String".equals(f.getType().getSimpleName()) && val.length >= 5) {
                        paramReq.setMaxLength(val[4]);
                    }
                }
                reqs.add(paramReq);
                continue block0;
            }
        }
        return reqs;
    }

    private static boolean isBase(String s) {
        return "String[]".equals(s) || "String".equals(s) || "Long".equals(s) || "long".equals(s) || "Long[]".equals(s) || "long[]".equals(s) || "Double".equals(s) || "double".equals(s) || "Double[]".equals(s) || "double[]".equals(s) || "Float".equals(s) || "float".equals(s) || "Float[]".equals(s) || "float[]".equals(s) || "Integer".equals(s) || "int".equals(s) || "Integer[]".equals(s) || "int[]".equals(s) || "Boolean".equals(s) || "boolean".equals(s) || "Boolean[]".equals(s) || "boolean[]".equals(s) || "Byte".equals(s) || "byte".equals(s) || "Byte[]".equals(s) || "byte[]".equals(s) || "Short".equals(s) || "short".equals(s) || "Short[]".equals(s) || "short[]".equals(s) || "Char".equals(s) || "char".equals(s) || "Char[]".equals(s) || "char[]".equals(s) || "BigDecimal".equals(s) || "LocalDate".equals(s) || "LocalDateTime".equals(s) || "LocalTime".equals(s);
    }

    public static Field[] getAllFields(Class clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != null) {
            Field[] declaredFields;
            for (Field field : declaredFields = clazz.getDeclaredFields()) {
                fieldList.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        Field[] fields = new Field[fieldList.size()];
        fieldList.toArray(fields);
        return fields;
    }

    static {
        client = null;
        root = null;
        list = new ArrayList<DocItem>();
    }
}

