/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.core.pojo.mybatis;

import cn.ezeyc.core.config.Const;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedJdbcTypes(value={JdbcType.VARCHAR})
@MappedTypes(value={Boolean[].class})
public class BooleanArrayTypeHandler
extends BaseTypeHandler<Boolean[]> {
    private static final Logger log = LoggerFactory.getLogger(BooleanArrayTypeHandler.class);

    public void setNonNullParameter(PreparedStatement preparedStatement, int i, Boolean[] objects, JdbcType jdbcType) throws SQLException {
        preparedStatement.setString(i, Arrays.stream(objects).map(Object::toString).collect(Collectors.joining(Const.dou)));
    }

    public Boolean[] getNullableResult(ResultSet resultSet, String s) throws SQLException {
        String v = resultSet.getString(s);
        if (v != null) {
            Boolean[] result = new Boolean[v.length()];
            for (int x = 0; x < v.split(Const.dou).length; ++x) {
                result[x] = Boolean.valueOf(v.split(Const.dou)[x]);
            }
            return result;
        }
        return null;
    }

    public Boolean[] getNullableResult(ResultSet resultSet, int i) throws SQLException {
        String v = resultSet.getString(i);
        if (v != null && !"".equals(v)) {
            Boolean[] result = new Boolean[v.length()];
            for (int x = 0; x < v.split(Const.dou).length; ++x) {
                result[x] = Boolean.valueOf(v.split(Const.dou)[x]);
            }
            return result;
        }
        return null;
    }

    public Boolean[] getNullableResult(CallableStatement callableStatement, int i) throws SQLException {
        String v = callableStatement.getString(i);
        if (v != null) {
            Boolean[] result = new Boolean[v.length()];
            for (int x = 0; x < v.split(Const.dou).length; ++x) {
                result[x] = Boolean.valueOf(v.split(Const.dou)[x]);
            }
            return result;
        }
        return null;
    }
}

