/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.core.pojo.mybatis;

import cn.ezeyc.core.config.Const;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedJdbcTypes(value={JdbcType.VARCHAR})
@MappedTypes(value={Float[].class})
public class FloatArrayTypeHandler
extends BaseTypeHandler<Float[]> {
    private static final Logger log = LoggerFactory.getLogger(FloatArrayTypeHandler.class);

    public void setNonNullParameter(PreparedStatement preparedStatement, int i, Float[] objects, JdbcType jdbcType) throws SQLException {
        preparedStatement.setString(i, Arrays.stream(objects).map(Object::toString).collect(Collectors.joining(Const.dou)));
    }

    public Float[] getNullableResult(ResultSet resultSet, String s) throws SQLException {
        String v = resultSet.getString(s);
        if (v != null && !"".equals(v)) {
            Float[] result = new Float[v.length()];
            for (int x = 0; x < v.split(Const.dou).length; ++x) {
                result[x] = Float.valueOf(v.split(Const.dou)[x]);
            }
            return result;
        }
        return null;
    }

    public Float[] getNullableResult(ResultSet resultSet, int i) throws SQLException {
        String v = resultSet.getString(i);
        if (v != null) {
            Float[] result = new Float[v.length()];
            for (int x = 0; x < v.split(Const.dou).length; ++x) {
                result[x] = Float.valueOf(v.split(Const.dou)[x]);
            }
            return result;
        }
        return null;
    }

    public Float[] getNullableResult(CallableStatement callableStatement, int i) throws SQLException {
        String v = callableStatement.getString(i);
        if (v != null) {
            Float[] result = new Float[v.length()];
            for (int x = 0; x < v.split(Const.dou).length; ++x) {
                result[x] = Float.valueOf(v.split(Const.dou)[x]);
            }
            return result;
        }
        return null;
    }
}

