/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.core.service;

import cn.ezeyc.core.config.Const;
import cn.ezeyc.core.config.UploadConfig;
import cn.ezeyc.core.enums.OfficeType;
import cn.ezeyc.core.util.OfficeTo;
import cn.ezeyc.core.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.noear.solon.annotation.Get;
import org.noear.solon.annotation.Inject;
import org.noear.solon.aspect.annotation.Service;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.model.Media;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.handle.UploadedFile;

@Service
public class FileService {
    @Inject
    private UploadConfig config;
    @Inject(value="${uploadType}", required=false)
    private String type = Const.qiniu;

    public String upload(UploadedFile file) throws IOException {
        if (this.type.equals(Const.qiniu)) {
            String date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy/MM/dd"));
            String name = date + Const.slanting + CloudClient.id().generate();
            if (file.name.contains(Const.dot)) {
                name = name + Util.getFileType(file.name);
            }
            Result put = CloudClient.file().put(name, new Media(file.content));
            return name;
        }
        if (this.type.equals(Const.local)) {
            String date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy/MM/dd"));
            String name = CloudClient.id().generate() + Util.getFileType(file.name);
            File newFile = new File(this.config.getUploadPath() + date);
            if (!newFile.exists()) {
                newFile.mkdirs();
            }
            file.transferTo(new File(newFile.getPath() + Const.slanting + name));
            return date + Const.slanting + name;
        }
        return "\u4e0a\u4f20\u7c7b\u578b\u672a\u786e\u5b9a";
    }

    public void down(Context ctx, String path) {
        if (this.type.equals(Const.qiniu)) {
            byte[] bytes = CloudClient.file().get(path).bodyAsByts();
            try {
                ctx.outputStream().write(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.type.equals(Const.local)) {
            File file = new File(this.config.getUploadPath(), path);
            try {
                ctx.outputAsFile(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Get
    public void view(Context ctx, String path, String officeType) {
        if (this.type.equals(Const.qiniu)) {
            byte[] bytes = CloudClient.file().get(path).bodyAsByts();
            try {
                ctx.outputStream().write(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.type.equals(Const.local)) {
            File file = new File(this.config.getUploadPath(), path);
            try {
                if (path.endsWith("PDF") || path.endsWith("pdf")) {
                    FileInputStream fis = new FileInputStream(file);
                    ctx.contentType("application/pdf");
                    ctx.output(fis.readAllBytes());
                } else if (path.endsWith("doc") || path.endsWith("DOC") || path.endsWith("docx") || path.endsWith("DOCX") || path.endsWith("xls") || path.endsWith("XLS") || path.endsWith("xlsx") || path.endsWith("XLSX")) {
                    if (officeType != null && !"".equals(officeType)) {
                        ctx.contentType("application/" + officeType);
                    } else {
                        ctx.contentType("application/pdf");
                    }
                    File newFile = null;
                    newFile = path.endsWith("doc") || path.endsWith("DOC") || path.endsWith("docx") || path.endsWith("DOCX") ? (officeType != null && "html".equals(officeType) ? OfficeTo.DocTo(file, OfficeType.HTML) : OfficeTo.DocTo(file, OfficeType.PDF)) : (officeType != null && "html".equals(officeType) ? OfficeTo.xlxTo(file, OfficeType.HTML) : OfficeTo.xlxTo(file, OfficeType.PDF));
                    FileInputStream fis = new FileInputStream(newFile);
                    if (officeType != null && "html".equals(officeType)) {
                        InputStreamReader input = new InputStreamReader((InputStream)fis, "UTF-8");
                        BufferedReader bf = new BufferedReader(input);
                        String content = "";
                        StringBuilder sb = new StringBuilder();
                        while (content != null && (content = bf.readLine()) != null) {
                            sb.append(content.trim());
                        }
                        bf.close();
                        input.close();
                        fis.close();
                        ctx.outputAsHtml(sb.toString());
                    } else {
                        ctx.output(fis.readAllBytes());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void del(String path) {
        File file;
        if (this.type.equals(Const.qiniu)) {
            CloudClient.file().delete(path);
        } else if (this.type.equals(Const.local) && (file = new File(this.config.getUploadPath() + path)).exists()) {
            file.delete();
        }
    }

    public void del(String[] path) {
        for (String s : path) {
            File file;
            if (this.type.equals(Const.qiniu)) {
                CloudClient.file().delete(s);
                continue;
            }
            if (!this.type.equals(Const.local) || !(file = new File(this.config.getUploadPath() + s)).exists()) continue;
            file.delete();
        }
    }
}

