/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.core.util;

import cn.ezeyc.core.annotation.Excel;
import cn.ezeyc.core.pojo.MyRuntimeException;
import cn.ezeyc.core.util.ClassUtil;
import cn.ezeyc.core.util.reflect;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.noear.solon.core.handle.Context;

public class ExcelUtil {
    public static void pcExportExcel(List list) {
        ExcelUtil.pcExportExcel(list, null, null);
    }

    public static void pcExportExcelName(List list, String fileName) {
        ExcelUtil.pcExportExcel(list, null, fileName);
    }

    public static void pcExportExcel(List list, String title) {
        ExcelUtil.pcExportExcel(list, title, null);
    }

    public static void pcExportExcel(List list, String title, String fileName) {
        ExcelUtil.export(list, null, title, fileName, true);
    }

    public static void exportExcel(List list, String path) {
        ExcelUtil.exportExcel(list, path, null);
    }

    public static void exportExcel(List list, String path, String title) {
        ExcelUtil.exportExcel(list, path, title, null);
    }

    public static void exportExcel(List list, String path, String title, String fileName) {
        ExcelUtil.export(list, path, title, fileName, false);
    }

    private static void export(List list, String path, String title, String fileName, Boolean pc) {
        Integer titles;
        XSSFWorkbook work = new XSSFWorkbook();
        Sheet sheet = work.createSheet();
        Cell fields = ClassUtil.getAllFields(list.get(0).getClass(), Excel.class);
        Integer rowInt = 0;
        if (title != null && !"".equals(title)) {
            CellRangeAddress cellAddresses = new CellRangeAddress(0, 0, 0, ((Field[])fields).length);
            sheet.addMergedRegion(cellAddresses);
            Integer n = rowInt;
            rowInt = rowInt + 1;
            titles = sheet.createRow(n.intValue());
            Cell cells = titles.createCell(0);
            cells.setCellValue(title);
            RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellAddresses, (Sheet)sheet);
            RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellAddresses, (Sheet)sheet);
            RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellAddresses, (Sheet)sheet);
            RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellAddresses, (Sheet)sheet);
        }
        if (((Field[])fields).length > 0) {
            titles = rowInt;
            rowInt = rowInt + 1;
            Row row = sheet.createRow(titles.intValue());
            int c = 0;
            for (Field f : fields) {
                Excel annotation = f.getAnnotation(Excel.class);
                if (annotation.type() != Excel.Type.ALL && annotation.type() != Excel.Type.EXPORT) continue;
                Cell cell = row.createCell(c++);
                cell.setCellValue(annotation.name());
            }
        }
        for (Object o : list) {
            Integer n = rowInt;
            rowInt = rowInt + 1;
            Row row = sheet.createRow(n.intValue());
            int c = 0;
            block7: for (Cell f : fields) {
                Excel annotation = f.getAnnotation(Excel.class);
                if (annotation.type() != Excel.Type.ALL && annotation.type() != Excel.Type.EXPORT) continue;
                Cell cell = row.createCell(c++);
                try {
                    f.setAccessible(true);
                    if (!("".equals(annotation.dateFormat()) || f.getType() != LocalDateTime.class && f.getType() != LocalTime.class && f.getType() != LocalDate.class)) {
                        cell.setCellValue(new SimpleDateFormat(annotation.dateFormat()).parse(f.get(o).toString()));
                        continue;
                    }
                    if (!"".equals(annotation.dictType())) continue;
                    if (!"".equals(annotation.readConverterExp())) {
                        String[] split = annotation.readConverterExp().split(",");
                        if (split.length <= 0) continue;
                        for (String s : split) {
                            String[] v = s.split("=");
                            if (v.length <= 0 || !v[0].equals(f.get(o).toString())) continue;
                            cell.setCellValue(v[1]);
                            continue block7;
                        }
                        continue;
                    }
                    if (!"".equals(annotation.suffix())) {
                        cell.setCellValue(f.get(o).toString() + annotation.suffix());
                        continue;
                    }
                    if (f.get(o) == null) continue;
                    cell.setCellValue(f.get(o).toString());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        try {
            if (fileName == null || "".equals(fileName)) {
                fileName = "\u8868\u683c.xlsx";
            }
            if (pc.booleanValue()) {
                ExcelUtil.download((Workbook)work, fileName);
            } else {
                ExcelUtil.write((Workbook)work, fileName, path);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List importExcel(File file, Class entity) {
        ArrayList list = new ArrayList();
        try {
            FileInputStream is = new FileInputStream(file);
            Field[] fields = ClassUtil.getAllFields(entity, Excel.class);
            XSSFWorkbook book = new XSSFWorkbook((InputStream)is);
            XSSFSheet sheet = book.getSheetAt(0);
            int rows = sheet.getPhysicalNumberOfRows();
            HashMap<Integer, String> cell = new HashMap<Integer, String>();
            for (int x = 0; x < rows; ++x) {
                XSSFRow row = sheet.getRow(x);
                if (x == 0) {
                    block3: for (int y = 0; y < row.getPhysicalNumberOfCells(); ++y) {
                        for (Field f : fields) {
                            Excel annotation = f.getAnnotation(Excel.class);
                            if (annotation.type() != Excel.Type.ALL && annotation.type() != Excel.Type.IMPORT || !annotation.name().equals(row.getCell(y).getStringCellValue())) continue;
                            cell.put(y, f.getName());
                            continue block3;
                        }
                    }
                    continue;
                }
                Object obj = entity.newInstance();
                block5: for (int y = 0; y < row.getPhysicalNumberOfCells(); ++y) {
                    for (Integer key : cell.keySet()) {
                        if (y != key) continue;
                        block7: for (Field f : fields) {
                            Excel annotation;
                            if (!f.getName().equals(cell.get(key)) || !"".equals((annotation = f.getAnnotation(Excel.class)).dictType())) continue;
                            if (!"".equals(annotation.readConverterExp())) {
                                String[] split = annotation.readConverterExp().split(",");
                                if (split.length <= 0) continue;
                                for (String s : split) {
                                    String[] v = s.split("=");
                                    if (v.length <= 0 || !v[1].equals(row.getCell(y).getStringCellValue())) continue;
                                    reflect.setNormal(f, f.getType(), entity, v[0]);
                                    continue block7;
                                }
                                continue;
                            }
                            if (!"".equals(annotation.suffix())) {
                                reflect.setNormal(f, f.getType(), entity, row.getCell(y).getStringCellValue().replace(annotation.suffix(), ""));
                                continue block5;
                            }
                            reflect.setNormal(f, f.getType(), entity, row.getCell(y).getStringCellValue());
                            continue block5;
                        }
                    }
                }
                list.add(obj);
            }
        }
        catch (Exception e) {
            throw new MyRuntimeException(e.getMessage());
        }
        return list;
    }

    private static void download(Workbook workbook, String fileName) throws IOException {
        Context ctx = Context.current();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        workbook.write((OutputStream)os);
        ctx.headerSet("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "utf-8"));
        ctx.contentType("application/octet-stream;charset=UTF-8");
        ctx.headerSet("Pargam", "no-cache");
        ctx.headerSet("Cache-Control", "no-cache");
        ctx.contentLength((long)os.size());
        ctx.headerSet("Content-Length", "" + os.size());
        OutputStream outputStream = ctx.outputStream();
        os.writeTo(outputStream);
        os.close();
        outputStream.flush();
    }

    private static void write(Workbook workbook, String fileName, String path) throws IOException {
        FileOutputStream os = null;
        ExcelUtil.setResponseHeader(fileName);
        File file = new File(path + "/" + fileName);
        os = new FileOutputStream(file);
        workbook.write((OutputStream)os);
        if (os != null) {
            ((OutputStream)os).close();
        }
    }

    private static void setResponseHeader(String fileName) {
        try {
            Context ctx = Context.current();
            fileName = new String(fileName.getBytes(), "UTF-8");
            ctx.contentType("application/octet-stream;charset=UTF-8");
            ctx.headerSet("Pragma", "no-cache");
            ctx.headerSet("Cache-Control", "no-cache");
            ctx.headerSet("Content-Disposition", "attachment;filename=" + fileName);
        }
        catch (UnsupportedEncodingException e) {
            throw new MyRuntimeException(e.getMessage());
        }
    }
}

