/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.core.util;

import cn.ezeyc.core.config.Const;
import cn.ezeyc.core.enums.OfficeType;
import com.aspose.cells.HtmlSaveOptions;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.SaveOptions;
import com.aspose.cells.Workbook;
import com.aspose.words.Document;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class OfficeTo {
    public static File DocTo(File file, OfficeType type) {
        String hz = file.getName().substring(file.getName().lastIndexOf(Const.dot) + 1);
        File newFile = new File(file.getPath().replace(hz, type.getValue()));
        if (newFile.exists()) {
            return newFile;
        }
        OutputStream os = null;
        try {
            Document doc = new Document(file.getPath());
            os = new FileOutputStream(newFile);
            if (OfficeType.PDF == type) {
                doc.save(os, 40);
            } else {
                doc.save(os, 50);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                os.flush();
                ((FileOutputStream)os).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return newFile;
    }

    public static File xlxTo(File file, OfficeType type) {
        String hz = file.getName().substring(file.getName().lastIndexOf(Const.dot) + 1);
        File newFile = new File(file.getPath().replace(hz, type.getValue()));
        if (newFile.exists()) {
            return newFile;
        }
        OutputStream os = null;
        try {
            Workbook workbook = new Workbook(file.getPath());
            os = new FileOutputStream(newFile);
            if (OfficeType.PDF == type) {
                PdfSaveOptions opts = new PdfSaveOptions();
                opts.setAllColumnsInOnePagePerSheet(true);
                workbook.save(os, (SaveOptions)opts);
            } else {
                HtmlSaveOptions opts = new HtmlSaveOptions();
                opts.setExportComments(true);
                workbook.save(os, (SaveOptions)opts);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                os.flush();
                ((FileOutputStream)os).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return newFile;
    }
}

