/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.core.util;

import cn.ezeyc.core.pojo.MyRuntimeException;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static Pattern linePattern = Pattern.compile("_(\\w)");
    private static Pattern humpPattern = Pattern.compile("[A-Z]");

    public static String getSubUtilSimple(String soap, String rgex) {
        Pattern pattern = Pattern.compile(rgex);
        Matcher m = pattern.matcher(soap);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    public static String[] delEmpty(String[] arr) {
        ArrayList<String> values = new ArrayList<String>();
        for (String ss : arr) {
            if ("".equals(ss)) continue;
            values.add(ss);
        }
        return values.toArray(new String[values.size()]);
    }

    public static boolean ip(String ip) {
        String regex = "\\A(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}\\z";
        return ip.matches(regex);
    }

    public static boolean number(String num) {
        String regex = "^[1-9]+[0-9]*$";
        return num.matches(regex);
    }

    public static Object[] convertArray(Class c, String value) {
        if (c == Long.class) {
            Object[] intArr = new Long[]{};
            if (StringUtils.isBlank((CharSequence)value)) {
                intArr = new Long[]{};
            } else {
                String[] valueArr = value.split(",");
                intArr = new Long[valueArr.length];
                for (int i = 0; i < valueArr.length; ++i) {
                    intArr[i] = Long.parseLong(valueArr[i]);
                }
            }
            return intArr;
        }
        if (c == Integer.class) {
            Object[] intArr = new Integer[]{};
            if (StringUtils.isBlank((CharSequence)value)) {
                intArr = new Integer[]{};
            } else {
                String[] valueArr = value.split(",");
                intArr = new Integer[valueArr.length];
                for (int i = 0; i < valueArr.length; ++i) {
                    intArr[i] = Integer.parseInt(valueArr[i]);
                }
            }
            return intArr;
        }
        if (c == Double.class) {
            Object[] intArr = new Double[]{};
            if (StringUtils.isBlank((CharSequence)value)) {
                intArr = new Double[]{};
            } else {
                String[] valueArr = value.split(",");
                intArr = new Double[valueArr.length];
                for (int i = 0; i < valueArr.length; ++i) {
                    intArr[i] = Double.parseDouble(valueArr[i]);
                }
            }
            return intArr;
        }
        if (c == Float.class) {
            Object[] intArr = new Float[]{};
            if (StringUtils.isBlank((CharSequence)value)) {
                intArr = new Float[]{};
            } else {
                String[] valueArr = value.split(",");
                intArr = new Float[valueArr.length];
                for (int i = 0; i < valueArr.length; ++i) {
                    intArr[i] = Float.valueOf(Float.parseFloat(valueArr[i]));
                }
            }
            return intArr;
        }
        Object[] valueArr = value.split(",");
        return valueArr;
    }

    public static Object[] jsonArrayConvert(Class c, Object object) {
        if (c == Long.class) {
            if (object != null && !"".equals(object)) {
                JSONArray list = new ArrayList();
                if (object instanceof Long || object instanceof Integer) {
                    list.add(object);
                } else if (object != "") {
                    list = JSONArray.parseArray((String)JSONObject.toJSONString((Object)object, (JSONWriter.Feature[])new JSONWriter.Feature[0]), (JSONReader.Feature[])new JSONReader.Feature[0]);
                }
                Object[] ids = new Long[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    ids[i] = Long.parseLong(list.get(i).toString());
                }
                return ids;
            }
            return null;
        }
        if (c == Integer.class) {
            JSONArray list = new ArrayList();
            if (object instanceof Integer) {
                list.add(object);
            } else if (object != "") {
                list = JSONArray.parseArray((String)JSONObject.toJSONString((Object)object, (JSONWriter.Feature[])new JSONWriter.Feature[0]), (JSONReader.Feature[])new JSONReader.Feature[0]);
            }
            Object[] ids = new Integer[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                ids[i] = Integer.parseInt(list.get(i).toString());
            }
            return ids;
        }
        if (c == Double.class) {
            JSONArray list = new ArrayList();
            if (object instanceof Double) {
                list.add(object);
            } else if (object != "") {
                list = JSONArray.parseArray((String)JSONObject.toJSONString((Object)object, (JSONWriter.Feature[])new JSONWriter.Feature[0]), (JSONReader.Feature[])new JSONReader.Feature[0]);
            }
            Object[] ids = new Double[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                ids[i] = Double.parseDouble(list.get(i).toString());
            }
            return ids;
        }
        if (c == Float.class) {
            JSONArray list = new ArrayList();
            if (object instanceof Float) {
                list.add(object);
            } else if (object != "") {
                list = JSONArray.parseArray((String)JSONObject.toJSONString((Object)object, (JSONWriter.Feature[])new JSONWriter.Feature[0]), (JSONReader.Feature[])new JSONReader.Feature[0]);
            }
            Object[] ids = new Float[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                ids[i] = Float.valueOf(Float.parseFloat(list.get(i).toString()));
            }
            return ids;
        }
        JSONArray list = new ArrayList();
        if (object instanceof String) {
            list.add(object);
        } else if (object != "") {
            list = JSONArray.parseArray((String)JSONObject.toJSONString((Object)object, (JSONWriter.Feature[])new JSONWriter.Feature[0]), (JSONReader.Feature[])new JSONReader.Feature[0]);
        }
        Object[] ids = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null) continue;
            try {
                ids[i] = URLDecoder.decode(String.valueOf(list.get(i).toString()), "UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new MyRuntimeException(e.getMessage());
            }
        }
        return ids;
    }

    public static String arrayToString(Object[] arr) {
        StringBuffer sb = new StringBuffer();
        for (int x = 0; x < arr.length; ++x) {
            if (x == arr.length - 1) {
                sb.append(arr[x]);
                continue;
            }
            sb.append(arr[x]).append(",");
        }
        return sb.toString();
    }

    public static String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static String toUpperCaseFirstOne(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String lineToHump(String str) {
        str = str.toLowerCase();
        Matcher matcher = linePattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String humpToLine2(String str) {
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String getFileType(File file) {
        return file.getName().substring(file.getName().indexOf("."), file.getName().length());
    }

    public static String rmLine(String str) {
        return str.replaceAll("-", "");
    }

    public static boolean isJson(String str) {
        boolean result = false;
        try {
            JSON.parseObject((String)str);
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static boolean isTaskCron(String cron) {
        if (StringUtils.isNotBlank((CharSequence)cron)) {
            String str = "0 * * * * ?";
            String regMiao = "([0-9]{1,2}|[0-9]{1,2}\\-[0-9]{1,2}|\\*|[0-9]{1,2}\\/[0-9]{1,2}|[0-9]{1,2}\\,[0-9]{1,2})";
            String regFen = "\\s([0-9]{1,2}|[0-9]{1,2}\\-[0-9]{1,2}|\\*|[0-9]{1,2}\\/[0-9]{1,2}|[0-9]{1,2}\\,[0-9]{1,2})";
            String regShi = "\\s([0-9]{1,2}|[0-9]{1,2}\\-[0-9]{1,2}|\\*|[0-9]{1,2}\\/[0-9]{1,2}|[0-9]{1,2}\\,[0-9]{1,2})";
            String regRi = "\\s([0-9]{1,2}|[0-9]{1,2}\\-[0-9]{1,2}|\\*|[0-9]{1,2}\\/[0-9]{1,2}|[0-9]{1,2}\\,[0-9]{1,2}|\\?|L|W|C)";
            String regYue = "\\s([0-9]{1,2}|[0-9]{1,2}\\-[0-9]{1,2}|\\*|[0-9]{1,2}\\/[0-9]{1,2}|[0-9]{1,2}\\,[0-9]{1,2}|JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)";
            String regZhou = "\\s([1-7]{1}|[1-7]{1}\\-[1-7]{1}|[1-7]{1}\\#[1-7]{1}|\\*|[1-7]{1}\\/[1-7]{1}|[1-7]{1}\\,[1-7]{1}|MON|TUES|WED|THUR|FRI|SAT|SUN|\\?|L|C)";
            String regNian = "(\\s([0-9]{4}|[0-9]{4}\\-[0-9]{4}|\\*|[0-9]{4}\\/[0-9]{4}|[0-9]{4}\\,[0-9]{4})){0,1}";
            String regEx = regMiao + regFen + regShi + regRi + regYue + regZhou + regNian;
            Pattern pat = Pattern.compile(regEx, 2);
            Matcher matcher = pat.matcher(str);
            return matcher.matches();
        }
        return false;
    }
}

