/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.edpenc;

import cn.ezeyc.edpenc.util.EncryptUtils;
import cn.ezeyc.edpenc.util.IoUtils;
import cn.ezeyc.edpenc.util.JarUtils;
import cn.ezeyc.edpenc.util.StrUtils;
import cn.ezeyc.edpenc.util.SysUtils;
import java.io.File;

public class JarDecryptor {
    private static final JarDecryptor SINGLE = new JarDecryptor();
    private char[] code = SysUtils.makeMarchCode();
    private static final String ENCRYPT_PATH = "META-INF/.classes/";

    public static JarDecryptor getInstance() {
        return SINGLE;
    }

    public byte[] doDecrypt(String projectPath, String fileName, char[] password) {
        char[] pass;
        File workDir = new File(projectPath);
        byte[] bytes = JarDecryptor.readEncryptedFile(workDir, fileName);
        if (bytes == null) {
            return null;
        }
        byte[] codeBytes = JarDecryptor.readEncryptedFile(workDir, "code");
        if (codeBytes != null) {
            if (!StrUtils.equal(EncryptUtils.md5(this.code), StrUtils.toChars(codeBytes))) {
                System.out.println("\u8be5\u9879\u76ee\u4e0d\u53ef\u5728\u6b64\u673a\u5668\u4e0a\u8fd0\u884c!\n");
                System.exit(-1);
            }
            pass = StrUtils.merger(fileName.toCharArray(), this.code);
            bytes = EncryptUtils.de(bytes, pass, 1);
        }
        password = JarDecryptor.readPassFromJar(workDir);
        pass = StrUtils.merger(password, fileName.toCharArray());
        bytes = EncryptUtils.de(bytes, pass, 1);
        return bytes;
    }

    public static byte[] readEncryptedFile(File workDir, String name) {
        byte[] bytes = null;
        if (workDir.isFile()) {
            bytes = JarUtils.getFileFromJar(workDir, ENCRYPT_PATH + name);
        } else {
            File file = new File(workDir, name);
            if (file.exists()) {
                bytes = IoUtils.readFileToByte(file);
            }
        }
        return bytes;
    }

    public static char[] readPassFromJar(File workDir) {
        byte[] passbyte = JarDecryptor.readEncryptedFile(workDir, "pass");
        if (passbyte != null) {
            char[] pass = StrUtils.toChars(passbyte);
            return EncryptUtils.md5(pass);
        }
        return null;
    }
}

