/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.edpenc.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.zip.CRC32;

public class IoUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, byte[] fileBytes) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            ((OutputStream)os).write(fileBytes, 0, fileBytes.length);
            os.flush();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IoUtils.close(os);
                throw throwable;
            }
            IoUtils.close(os);
        }
        IoUtils.close(os);
    }

    public static byte[] readFileToByte(File file) {
        try {
            FileInputStream inputStream = new FileInputStream(file);
            return IoUtils.toBytes(inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(InputStream input) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            int n;
            byte[] buffer = new byte[4096];
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
            }
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            IoUtils.close(output, input);
            throw throwable;
        }
        IoUtils.close(output, input);
        return byArray;
    }

    public static void listFile(List<File> fileList, File dir, String endWith) {
        if (!dir.exists()) {
            throw new IllegalArgumentException("\u76ee\u5f55[" + dir.getAbsolutePath() + "]\u4e0d\u5b58\u5728");
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    IoUtils.listFile(fileList, f, endWith);
                    continue;
                }
                if (!f.isFile() || !f.getName().endsWith(endWith)) continue;
                fileList.add(f);
            }
        }
    }

    public static void listFile(List<File> filess, File dir) {
        File[] files;
        if (!dir.exists()) {
            throw new IllegalArgumentException("\u76ee\u5f55[" + dir.getAbsolutePath() + "]\u4e0d\u5b58\u5728");
        }
        if (!dir.getName().toLowerCase().endsWith("lib") && (files = dir.listFiles()) != null) {
            for (File f : files) {
                filess.add(f);
                if (!f.isDirectory()) continue;
                IoUtils.listFile(filess, f);
            }
        }
    }

    public static void delete(File dir) {
        if (!dir.exists()) {
            return;
        }
        if (dir.isFile()) {
            dir.delete();
        } else {
            File[] files = dir.listFiles();
            if (files != null) {
                for (File f : files) {
                    IoUtils.delete(f);
                }
            }
        }
        dir.delete();
    }

    public static long crc32(byte[] bytes) {
        CRC32 crc = new CRC32();
        crc.update(bytes);
        return crc.getValue();
    }

    public static void close(Closeable ... outs) {
        if (outs != null) {
            for (Closeable out : outs) {
                if (out == null) continue;
                try {
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTxtFile(File file) {
        StringBuffer txt = new StringBuffer();
        InputStreamReader read = null;
        BufferedReader bufferedReader = null;
        try {
            String lineTxt;
            read = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
            bufferedReader = new BufferedReader(read);
            while ((lineTxt = bufferedReader.readLine()) != null) {
                txt.append(lineTxt).append("\r\n");
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IoUtils.close(bufferedReader, read);
                throw throwable;
            }
            IoUtils.close(bufferedReader, read);
        }
        IoUtils.close(bufferedReader, read);
        return txt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTxtFile(File file, String txt) {
        BufferedWriter out = null;
        try {
            if (!file.exists()) {
                file.mkdirs();
                file.delete();
                file.createNewFile();
            }
            out = new BufferedWriter(new FileWriter(file));
            out.write(txt);
            out.flush();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IoUtils.close(out);
                throw throwable;
            }
            IoUtils.close(out);
        }
        IoUtils.close(out);
    }

    public static byte[] merger(byte[] ... bts) {
        int lenght = 0;
        for (byte[] b : bts) {
            lenght += b.length;
        }
        byte[] bt = new byte[lenght];
        int lastLength = 0;
        for (byte[] b : bts) {
            System.arraycopy(b, 0, bt, lastLength, b.length);
            lastLength += b.length;
        }
        return bt;
    }
}

