<template>
  <view style="padding: 100rpx;">
    <edp-form  @save="save" v-model="obj"  size="small" >
      <edp-text type="hidden" prop="id" label="主键"  v-model="obj.id" />
      <!-- 字段【生成修改】-->
      <template v-slot:btn>
        <edp-btn   v-if="!route.read&&permissions['${table_name?replace('_',':')}:save']" formType="submit" type="primary" icon="icon-baocun">保存</edp-btn>
        <edp-btn   v-if="!route.read" formType="reset" type="info" icon="icon-zhongzhi">重置</edp-btn>
        <edp-btn     icon="icon-close"   @click="cancel">取消</edp-btn>
      </template>

    </edp-form>
  </view>
</template>

<script>
  import {ref,computed} from 'vue';
  import {useStore,mapGetters} from 'vuex'
  export default {
    //权限
    computed: {
      ...mapGetters([ "permissions"]),
    },
    setup(){
      const store = useStore()
      //路由
      const route=uni.$currentFirstRouter
      //获取字典
      //obj对象【生成修改】
      const obj=ref(route.param!=undefined&&route.param.length>0?route.param[0]:{});
      //保存
      const save=()=>{
        uni.request({
          service:'${service}',
          url:'/${url}/save',
          data:obj.value,
          success: (e) => {
            if(e.code=200){
              uni.$msg({type:'success',message:'保存成功'}).then(()=>{
                cancel()
              })
            }else{
              uni.$msg({type:'error',message:e.message})
            }
          }
        })
      }
      //关闭
      const cancel=()=>{
        //关闭tag【方法，关闭地址】
        store.commit("del_tag","/${service}/${url}/edit");
        //跳转前一个页面
        uni.$router.push(store.getters.currentTag)
      }
      return {route,obj,save,cancel,list}
    }
  }
</script>
<style scoped>
</style>
