<template>
  <view>
    <edp-query>
      <!-- 查询条件【生成修改】-->
      <template v-slot:btn>
        <edp-btn type="primary"   @click="search" icon="icon-chaxun">查询</edp-btn>
        <edp-btn type="info"   @click="reset" icon="icon-zhongzhi">重置</edp-btn>
      </template>
    </edp-query>
    <!-- 表格 -->
    <edp-table ref="table" border 	service="${service}" 	url="/${url}/list" delUrl="/${url}/del" :field="field"
               :permission="{add:permissions['${table_name?replace('_',':')}:add'],view:permissions['${table_name?replace('_',':')}:view'],
									save:permissions['${table_name?replace('_',':')}:save'],del:permissions['${table_name?replace('_',':')}:del']}"
               :checkbox="true" :xh="true"
               :btn="{barAdd:true,barEdit:true,barDel:true,view:true,edit:true,del:true}"
               v-model:query="query"
               v-model:checkObj="ckeckObj"
               v-model:check="ckeck"
               @add="add"
               @edit="edit"
               @view="view"
               @del="del"
               @call="tips"
    >
    </edp-table>
  </view>
</template>
<script>
  import {ref} from 'vue';
  import {useStore,mapGetters} from 'vuex'
  import {toDirect} from '@/js/toDirect.js'
  export default {
    //权限
    computed: {
      ...mapGetters([ "permissions"]),
    },
    setup(){
      const store = useStore()
      //创建人、修改人显示
      //表格
      const table=ref(null);
      //字段【生成替换】
      const field=ref([
        <#if column?exists>
        <#list column as model>
        {label: "${model.columnComment}", prop: "${model.changeColumnName}"},
        </#list>
        </#if>
      ])
      //查询值
      const query=ref({});
      //表格选中ids
      const ckeck=ref([])
      //表格选中对象集合
      const ckeckObj=ref([])
      //查询
      const search=()=>{
        table.value.doQuery()
      }
      //查询回调
      const tips=(e)=>{

      }
      //重置
      const reset=()=>{
        table.value.doReset()
      }
      //新增
      const add=()=>{
        uni.$router.push({label:"新增",path:"/${service}/${url}/edit"})
      }
      //编辑
      const edit=(item)=>{
        uni.$router.push({label:"编辑",path:"/${service}/${url}/edit",param:item})
      }
      //查看
      const view=(item)=>{
        uni.$router.push({label:"查看",path:"/${service}/${url}/edit",param:item,read:true})

      }
      //删除
      const del=(item,callBack)=>{
        callBack(true);
      }
      return {tips,table,field,query,ckeck,ckeckObj,search,reset,add,edit,del,view,list}
    }
  }
</script>

<style scoped>

</style>

