<template>
  <!-- 树表单 -->
  <edp-tree-form   :data="treeList" @treeClick="treeClick" v-model="obj" @save="save">
    <!-- 表单 -->
    <edp-text type="hidden"  v-model="obj.id" />
    <edp-text type="hidden"    v-model="obj.pid" />
    <!-- 字段【生成修改】-->
    <!-- 表单按钮 -->
    <template v-slot:btn>
      <edp-btn @click="add" v-if="permissions['${table_name?replace('_',':')}:add']" size="small" type="primary">新增</edp-btn>
      <edp-btn formType="submit" v-if="permissions['${table_name?replace('_',':')}:save']" size="small" type="warn">保存</edp-btn>
      <edp-btn @click="del" v-if="permissions['${table_name?replace('_',':')}:del']" size="small" type="danger">删除</edp-btn>
      <edp-btn @click="clean"   size="small" type="info">清空</edp-btn>
    </template>
  </edp-tree-form>
</template>
<script>
  import {ref,onMounted} from "vue";
  import { useStore,mapGetters} from "vuex";
  export default {
    name: "${remark}",
    //权限
    computed: {
      ...mapGetters([ "permissions"]),
    },
    setup(){
      //存储
      const store=useStore();

      //表单对象【生成修改】
      const obj = ref({})
      //查询树数据
      const treeList=ref([]);
      onMounted(()=>{
        uni.request({
          service:"${service}",
          url:"/${url}/tree",
          success: (e) => {
            treeList.value=e.data
          }
        })
      })
      //树节点点击事件
      const treeClick=(node)=>{
        //回显
        obj.value=node
      }
      //表单保存事件
      const save=()=> {
        uni.request({
          service:'${service}',
          url:"/${url}/save",
          data:obj.value,
          success: (e) => {
            if(e.code==200){
              uni.$msg({type:'success',message:"保存成功"})
            }else{
              uni.$msg({type:'danger',message:"保存失败"})
            }
          }
        })
      }
      //清空
      const clean=()=>{
        uni.$msg({type:"success",message:"请选择树节点"})
        obj.value={pid:obj.value.pid}
      }
      //新增
      const add=()=>{

        if(obj.value.id==""){
          uni.$msg({type:"warn",message:"请选择树节点"})
          return ;
        }

        //将节点id赋值给子节点pid
        obj.value={pid:obj.value.id}
      }
      //删除
      const  del=()=>{
        if(obj.value.id==""){
          uni.$msg({type:"warn",message:"请选择树节点"})
          return ;
        }
        uni.$confirm({type:"danger",message:"确认删除？删除后不可恢复!",title:"删除",sure:(e)=>{
            if(e){
              uni.request({
                method:'GET',
                service:'${service}',
                url:"/${url}/del?ids="+obj.value.id,
                success: (e) => {
                  if(e.code==200){
                    uni.$msg({type:'success',message:"删除成功"})
                  }else{
                    uni.$msg({type:'danger',message:"删除失败"})
                  }
                }
              })
            }

          }})
        //执行删除

      }
      return {treeList,obj,yesNo,treeClick,save,clean,del,add}
    }
  }
</script>
<style scoped>
</style>