/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.edpaliplug.util;

import cn.ezeyc.edpaliplug.config.AliMp;
import cn.ezeyc.edpaliplug.pojo.Pay;
import cn.ezeyc.edpaliplug.util.AliUtil;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.domain.AlipayFundAuthOrderAppFreezeModel;
import com.alipay.api.domain.AlipayFundAuthOrderUnfreezeModel;
import com.alipay.api.domain.AlipayTradePayModel;
import com.alipay.api.request.AlipayFundAuthOrderAppFreezeRequest;
import com.alipay.api.request.AlipayFundAuthOrderUnfreezeRequest;
import com.alipay.api.request.AlipayTradeCreateRequest;
import com.alipay.api.request.AlipayTradePayRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.response.AlipayFundAuthOrderAppFreezeResponse;
import com.alipay.api.response.AlipayFundAuthOrderUnfreezeResponse;
import com.alipay.api.response.AlipayTradeCreateResponse;
import com.alipay.api.response.AlipayTradePayResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;

public class AliPayUtil {
    public static AlipayTradeCreateResponse pay(AliMp mp, Pay pay) {
        AlipayTradeCreateRequest request = new AlipayTradeCreateRequest();
        JSONObject bizContent = new JSONObject();
        bizContent.put("total_amount", (Object)pay.getTotalAmount());
        bizContent.put("out_trade_no", (Object)pay.getOutTradeNo());
        bizContent.put("subject", (Object)pay.getSubject());
        bizContent.put("buyer_id", (Object)pay.getBuyerId());
        request.setBizContent(bizContent.toString());
        request.setNotifyUrl(mp.getPayNotifyUrl());
        return (AlipayTradeCreateResponse)AliUtil.request((AlipayRequest)request, mp);
    }

    public static AlipayTradeRefundResponse refund(AliMp mp, Pay pay) {
        AlipayTradeRefundRequest request = new AlipayTradeRefundRequest();
        JSONObject bizContent = new JSONObject();
        bizContent.put("trade_no", (Object)pay.getTradeNo());
        bizContent.put("out_trade_no", (Object)pay.getOutTradeNo());
        bizContent.put("refund_amount", (Object)pay.getTotalAmount());
        request.setBizContent(bizContent.toString());
        request.setNotifyUrl(mp.getRefundNotifyUrl());
        return (AlipayTradeRefundResponse)AliUtil.request((AlipayRequest)request, mp);
    }

    public static AlipayFundAuthOrderAppFreezeResponse freeze(AliMp mp, Pay pay) {
        AlipayFundAuthOrderAppFreezeRequest request = new AlipayFundAuthOrderAppFreezeRequest();
        AlipayFundAuthOrderAppFreezeModel model = new AlipayFundAuthOrderAppFreezeModel();
        model.setOrderTitle("\u5c3a\u7d20\u9884\u6388\u6743");
        model.setOutOrderNo(pay.getOutTradeNo());
        model.setProductCode("PRE_AUTH_ONLINE");
        model.setAmount(String.valueOf(pay.getTotalAmount()));
        model.setPayTimeout("30m");
        request.setBizModel((AlipayObject)model);
        request.setNotifyUrl(mp.getFreezeNotify());
        return (AlipayFundAuthOrderAppFreezeResponse)AliUtil.request((AlipayRequest)request, mp);
    }

    public static AlipayTradePayResponse freezePay(AliMp mp, Pay pay) {
        AlipayTradePayRequest request = new AlipayTradePayRequest();
        AlipayTradePayModel model = new AlipayTradePayModel();
        model.setOutTradeNo(pay.getOutTradeNo());
        model.setProductCode("PRE_AUTH_ONLINE");
        model.setSubject("\u5c3a\u7d20\uff1a\u9884\u6388\u6743\u8f6c\u652f\u4ed8");
        model.setTotalAmount(String.valueOf(pay.getTotalAmount()));
        model.setSellerId(mp.getCompanyId());
        model.setBuyerId(pay.getBuyerId());
        model.setBody("\u9884\u6388\u6743\u51bb\u7ed3\u8f6c\u652f\u4ed8:" + pay.getOutTradeNo());
        request.setBizModel((AlipayObject)model);
        request.setNotifyUrl(mp.getFreezePayNotify());
        return (AlipayTradePayResponse)AliUtil.request((AlipayRequest)request, mp);
    }

    public static AlipayFundAuthOrderUnfreezeResponse unFreeze(AliMp mp, Pay pay) {
        AlipayFundAuthOrderUnfreezeRequest request = new AlipayFundAuthOrderUnfreezeRequest();
        AlipayFundAuthOrderUnfreezeModel model = new AlipayFundAuthOrderUnfreezeModel();
        request.setBizModel((AlipayObject)model);
        request.setNotifyUrl(mp.getUnFreezeNotify());
        return (AlipayFundAuthOrderUnfreezeResponse)AliUtil.request((AlipayRequest)request, mp);
    }
}

