/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.edpcommon.pojo;

import java.io.Serializable;
import java.util.List;

public class Page<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int PAGE_SIZES = 15;
    public static final int CURRENT_PAGE = 1;
    private int pageNo = 1;
    private int pageSize = 15;
    private long total = -1L;
    private long totalPage = -1L;
    private int startIndex;
    private int endIndex;
    private List<T> results;

    private void calculateTotalPage() {
        if (this.total < 0L) {
            this.total = 0L;
        }
        this.totalPage = this.total % (long)this.pageSize == 0L ? this.total / (long)this.pageSize : this.total / (long)this.pageSize + 1L;
    }

    public Page() {
    }

    private void calculatorPageNo() {
        this.startIndex = this.pageNo > 0 ? (this.pageNo - 1) * this.pageSize : 0;
        this.endIndex = this.pageNo * this.pageSize;
    }

    public Page(int pageNo, int pageSize) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.calculatorPageNo();
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        if (pageNo <= 0) {
            this.pageNo = 1;
        }
        this.pageNo = pageNo;
        this.calculatorPageNo();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (pageSize <= 0) {
            this.pageSize = 15;
        }
        this.pageSize = pageSize;
        this.calculatorPageNo();
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotalCount(long totalCount) {
        this.total = totalCount;
        this.calculateTotalPage();
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }

    public List<T> getResults() {
        return this.results;
    }

    public void setResults(List<T> results) {
        this.results = results;
    }

    public String getPageSql() {
        return " limit " + (this.pageNo - 1) * this.pageSize + "," + this.pageSize;
    }
}

