/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.edpcommon.pojo;

import cn.ezeyc.edpcommon.enums.ResultEnum;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ResultBody<T>
implements Serializable {
    private static final long serialVersionUID = -6190689122701100762L;
    private int code = 0;
    private String message;
    private T data;
    private Map<String, Object> extra;
    private long timestamp = System.currentTimeMillis();

    public static <T> ResultBody success() {
        return new ResultBody<T>().setMessage(ResultEnum.OK.getMessage()).setCode(ResultEnum.OK.getCode());
    }

    public static <T> ResultBody success(T data) {
        return new ResultBody<T>().setData(data).setMessage(ResultEnum.OK.getMessage()).setCode(ResultEnum.OK.getCode());
    }

    public static <T> ResultBody success(String msg, T result) {
        return new ResultBody<T>().setMessage(msg).setData(result).setCode(ResultEnum.OK.getCode());
    }

    public static ResultBody failed(String msg) {
        if (msg == null) {
            return new ResultBody().setCode(ResultEnum.error.getCode()).setMessage(ResultEnum.error.getMessage());
        }
        return new ResultBody().setCode(ResultEnum.OperateField.getCode()).setMessage(msg);
    }

    public static ResultBody failed() {
        return new ResultBody().setCode(ResultEnum.OperateField.getCode()).setMessage(ResultEnum.OperateField.getMessage());
    }

    public static ResultBody failed(Integer code, String msg) {
        return new ResultBody().setCode(code).setMessage(msg);
    }

    public static ResultBody failed(ResultEnum code) {
        return ResultBody.failed(code.getCode(), code.getMessage());
    }

    public int getCode() {
        return this.code;
    }

    public ResultBody setCode(int code) {
        this.code = code;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public ResultBody setMessage(String message) {
        this.message = message;
        return this;
    }

    public T getData() {
        return this.data;
    }

    public ResultBody setData(T data) {
        this.data = data;
        return this;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ResultBody setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Map<String, Object> getExtra() {
        return this.extra;
    }

    public ResultBody setExtra(Map<String, Object> extra) {
        this.extra = extra;
        return this;
    }

    public ResultBody putExtra(String key, Object value2) {
        if (this.extra == null) {
            this.extra = new HashMap<String, Object>(1);
        }
        this.extra.put(key, value2);
        return this;
    }

    public ResultBody put(String key, Object value2) {
        HashMap<String, Object> map = null;
        if (this.data == null) {
            map = new HashMap<String, Object>(1);
            map.put(key, value2);
            this.setData(map);
        } else if (this.getData() instanceof Map) {
            ((Map)this.getData()).put(key, value2);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{code:" + this.code + ",message:'" + this.message + "',timestamp:" + this.timestamp + ",extra:'" + JSONObject.toJSONString(this.extra) + "'}");
        return sb.toString();
    }
}

