/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.edpcommon.util;

import cn.ezeyc.edpcommon.annotation.client.client;
import cn.ezeyc.edpcommon.annotation.framework.bean;
import cn.ezeyc.edpcommon.annotation.framework.configuration;
import cn.ezeyc.edpcommon.pojo.ZdConst;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassUtil {
    public static Field getField(Class clazz, String name) {
        Field field;
        block3: {
            field = null;
            try {
                if (clazz != Object.class && clazz != null) {
                    field = clazz.getDeclaredField(name);
                }
            }
            catch (NoSuchFieldException e) {
                if (field != null) break block3;
                field = ClassUtil.getField(clazz.getSuperclass(), name);
            }
        }
        return field;
    }

    public static Field[] getAllFields(Class clazz, Class<? extends Annotation> ... an) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != null) {
            if (an.length > 0) {
                Field[] declaredFields;
                for (Field field : declaredFields = clazz.getDeclaredFields()) {
                    for (Class<? extends Annotation> c : an) {
                        if (!field.isAnnotationPresent(c)) continue;
                        fieldList.add(field);
                    }
                }
            }
            clazz = clazz.getSuperclass();
        }
        Field[] fields = new Field[fieldList.size()];
        fieldList.toArray(fields);
        return fields;
    }

    public static Field[] getAllFields(Class clazz, Class<? extends Annotation> an) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != null) {
            Field[] declaredFields;
            for (Field field : declaredFields = clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(an)) continue;
                fieldList.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        Field[] fields = new Field[fieldList.size()];
        fieldList.toArray(fields);
        return fields;
    }

    public static Field[] getAllFields(Class clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != null) {
            Field[] declaredFields;
            for (Field field : declaredFields = clazz.getDeclaredFields()) {
                fieldList.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        Field[] fields = new Field[fieldList.size()];
        fieldList.toArray(fields);
        return fields;
    }

    public static List<Class> getAllClassByInterface(Class c) {
        String packageName;
        Set<Class<?>> allClass;
        ArrayList returnClassList = null;
        if (c.isInterface() && (allClass = ClassUtil.getClasses(packageName = c.getPackage().getName())) != null) {
            returnClassList = new ArrayList();
            for (Class<?> classes : allClass) {
                if (!c.isAssignableFrom(classes) || c.equals(classes)) continue;
                returnClassList.add(classes);
            }
        }
        return returnClassList;
    }

    public static String[] getPackageAllClassName(String classLocation, String packageName) {
        String[] packagePathSplit = packageName.split("[.]");
        Object realClassLocation = classLocation;
        int packageLength = packagePathSplit.length;
        for (int i = 0; i < packageLength; ++i) {
            realClassLocation = (String)realClassLocation + File.separator + packagePathSplit[i];
        }
        File packeageDir = new File((String)realClassLocation);
        if (packeageDir.isDirectory()) {
            String[] allClassName = packeageDir.list();
            return allClassName;
        }
        return null;
    }

    public static Set<Class<?>> getClasses(String packageName) {
        HashSet classes = new HashSet();
        boolean recursive = true;
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    ClassUtil.findAndAddClassesInPackageByFile(packageName, filePath, recursive, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.charAt(0) == '/') {
                            name = name.substring(1);
                        }
                        if (!name.startsWith(packageDirName)) continue;
                        int idx = name.lastIndexOf(47);
                        if (idx != -1) {
                            packageName = name.substring(0, idx).replace('/', '.');
                        }
                        if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                        String className = name.substring(packageName.length() + 1, name.length() - 6);
                        try {
                            Class<?> aClass = Class.forName(packageName + "." + className);
                            if (!aClass.isAnnotationPresent(configuration.class) && !aClass.isAnnotationPresent(bean.class) && !aClass.isAnnotationPresent(client.class) && !className.endsWith(ZdConst.end_with_service_impl) && !className.endsWith(ZdConst.end_with_control) && !className.endsWith(ZdConst.end_with_Dao)) continue;
                            classes.add(aClass);
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }

    public static void findAndAddClassesInPackageByFile(String packageName, String packagePath, final boolean recursive, Set<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                ClassUtil.findAndAddClassesInPackageByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                Class<?> aClass = Class.forName(packageName + "." + className);
                if (!aClass.isAnnotationPresent(configuration.class) && !aClass.isAnnotationPresent(bean.class) && !aClass.isAnnotationPresent(client.class) && !className.endsWith(ZdConst.end_with_service_impl) && !className.endsWith(ZdConst.end_with_control) && !className.endsWith(ZdConst.end_with_Dao)) continue;
                classes.add(aClass);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

