/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.edpenc;

import cn.ezeyc.edpenc.CoreAgent;
import cn.ezeyc.edpenc.util.ClassUtils;
import cn.ezeyc.edpenc.util.Const;
import cn.ezeyc.edpenc.util.EncryptUtils;
import cn.ezeyc.edpenc.util.IoUtils;
import cn.ezeyc.edpenc.util.JarUtils;
import cn.ezeyc.edpenc.util.StrUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.ClassPool;
import javassist.NotFoundException;

public class Encryptor {
    private final String jarPath;
    private char[] password = null;
    private List<String> packages = null;
    private List<String> jars = null;
    private char[] code = null;
    private final String baseDir;
    private File targetDir = null;
    private final Map<String, String> resolveClassName = new HashMap<String, String>();

    public Encryptor(String baseDir, String jarPath) {
        this.baseDir = baseDir;
        this.jarPath = jarPath;
    }

    public void doEncryptJar() {
        if (!this.jarPath.endsWith(".jar")) {
            throw new RuntimeException("jar\u6587\u4ef6\u683c\u5f0f\u6709\u8bef");
        }
        if (!new File(this.jarPath).exists()) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728:" + this.jarPath);
        }
        System.out.println("\u673a\u5668\u7ed1\u5b9a\uff1a" + (this.code != null && this.code.length > 0 ? "\u662f" : "\u5426"));
        this.targetDir = new File(this.jarPath.replace(".jar", "__temp__"));
        List<String> allFile = JarUtils.unJar(this.jarPath, this.targetDir.getAbsolutePath());
        ArrayList libJarFiles = new ArrayList();
        this.jars.forEach(path -> {
            if (path.toLowerCase().endsWith(".jar")) {
                List<String> files = JarUtils.unJar(path, this.targetDir.getAbsolutePath() + "/lib");
                libJarFiles.addAll(files);
            }
        });
        allFile.addAll(libJarFiles);
        List<File> classFiles = this.filterClasses(allFile);
        this.addClassFinalAgent();
        this.encryptClass(classFiles);
        this.clearClassMethod(classFiles);
        this.packageJar();
    }

    public List<File> filterClasses(List<String> allFile) {
        ArrayList<File> classFiles = new ArrayList<File>();
        allFile.forEach(file -> {
            if (!file.endsWith(".class")) {
                return;
            }
            String className = this.resolveClassName((String)file, true);
            if (StrUtils.findClass(this.packages, className)) {
                classFiles.add(new File((String)file));
            }
        });
        return classFiles;
    }

    private void encryptClass(List<File> classFiles) {
        ArrayList encryptClasses = new ArrayList();
        File metaDir = new File(this.targetDir, "META-INF" + File.separator + ".classes");
        if (!metaDir.exists()) {
            metaDir.mkdirs();
        }
        char[] randChars = EncryptUtils.randChar(32);
        this.password = EncryptUtils.md5(randChars);
        File configPass = new File(metaDir, "pass");
        IoUtils.writeFile(configPass, StrUtils.toBytes(randChars));
        if (StrUtils.isNotEmpty(this.code)) {
            File configCode = new File(metaDir, "code");
            IoUtils.writeFile(configCode, StrUtils.toBytes(EncryptUtils.md5(this.code)));
        }
        classFiles.forEach(classFile -> {
            String className = classFile.getName();
            if (className.endsWith(".class")) {
                className = this.resolveClassName(classFile.getAbsolutePath(), true);
            }
            byte[] bytes = IoUtils.readFileToByte(classFile);
            char[] pass = StrUtils.merger(this.password, className.toCharArray());
            bytes = EncryptUtils.en(bytes, pass, 1);
            if (StrUtils.isNotEmpty(this.code)) {
                pass = StrUtils.merger(className.toCharArray(), this.code);
                bytes = EncryptUtils.en(bytes, pass, 1);
            }
            File targetFile = new File(metaDir, className);
            IoUtils.writeFile(targetFile, bytes);
            encryptClasses.add(className);
        });
        char[] pchar = EncryptUtils.md5(StrUtils.merger(this.password, EncryptUtils.SALT));
        pchar = EncryptUtils.md5(StrUtils.merger(EncryptUtils.SALT, pchar));
        IoUtils.writeFile(new File(metaDir, "passHash"), StrUtils.toBytes(pchar));
    }

    private void clearClassMethod(List<File> classFiles) {
        ClassPool pool = ClassPool.getDefault();
        ClassUtils.loadClassPath(pool, new File(this.baseDir + File.separator + "lib"));
        ArrayList classPaths = new ArrayList();
        classFiles.forEach(classFile -> {
            String classPath = this.resolveClassName(classFile.getAbsolutePath(), false);
            if (classPaths.contains(classPath)) {
                return;
            }
            try {
                pool.insertClassPath(classPath);
            }
            catch (NotFoundException e) {
                System.out.println(e.getMessage());
            }
            classPaths.add(classPath);
        });
        classFiles.forEach(classFile -> {
            String className = this.resolveClassName(classFile.getAbsolutePath(), true);
            byte[] bts = null;
            try {
                bts = ClassUtils.rewriteAllMethods(pool, className);
                System.out.println("clean method: " + className);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            if (bts != null) {
                IoUtils.writeFile(classFile, bts);
            }
        });
    }

    public void addClassFinalAgent() {
        ArrayList<String> thisJarPaths = new ArrayList<String>();
        thisJarPaths.add(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath());
        thisJarPaths.forEach(thisJar -> {
            File thisJarFile = new File((String)thisJar);
            if (thisJar.endsWith(".jar")) {
                List<String> includeFiles = Arrays.asList(Const.CLASS_FINAL_FILES);
                JarUtils.unJar(thisJar, this.targetDir.getAbsolutePath(), includeFiles);
            } else if (thisJar.endsWith("/classes/")) {
                ArrayList<File> files = new ArrayList<File>();
                IoUtils.listFile(files, new File((String)thisJar));
                files.forEach(file -> {
                    String className = file.getAbsolutePath().substring(thisJarFile.getAbsolutePath().length());
                    File targetFile = this.targetDir;
                    targetFile = new File(targetFile, className);
                    if (file.isDirectory()) {
                        targetFile.mkdirs();
                    } else if (StrUtils.containsArray(file.getAbsolutePath(), Const.CLASS_FINAL_FILES)) {
                        byte[] bytes = IoUtils.readFileToByte(file);
                        IoUtils.writeFile(targetFile, bytes);
                    }
                });
            }
        });
        File manifest = new File(this.targetDir, "META-INF/MANIFEST.MF");
        String preMain = "Premain-Class: " + CoreAgent.class.getName();
        String[] txts = new String[]{};
        if (manifest.exists()) {
            txts = IoUtils.readTxtFile(manifest).split("\r\n");
        }
        String str = StrUtils.insertStringArray(txts, preMain, "Main-Class:");
        IoUtils.writeTxtFile(manifest, str + "\r\n\r\n");
    }

    private void packageJar() {
        String targetJar = this.jarPath.replace(".JAR", "-encrypted.jar");
        JarUtils.doJar(this.targetDir.getAbsolutePath(), targetJar);
        IoUtils.delete(this.targetDir);
        System.out.println("package: " + targetJar);
    }

    private String resolveClassName(String fileName, boolean classOrPath) {
        String clsPath;
        String clsName;
        String result = this.resolveClassName.get(fileName + classOrPath);
        if (result != null) {
            return result;
        }
        String file = fileName.substring(0, fileName.length() - 6);
        String kClasses = File.separator + "classes" + File.separator;
        String kLib = File.separator + "lib" + File.separator;
        if (file.contains(kLib)) {
            clsName = file.substring(file.indexOf("__temp__", file.indexOf(kLib)) + "__temp__".length() + 1);
            clsPath = file.substring(0, file.length() - clsName.length() - 1);
        } else if (file.contains(kClasses)) {
            clsName = file.substring(file.indexOf(kClasses) + kClasses.length());
            clsPath = file.substring(0, file.length() - clsName.length() - 1);
        } else {
            clsName = file.substring(file.indexOf("__temp__") + "__temp__".length() + 1);
            clsPath = file.substring(0, file.length() - clsName.length() - 1);
        }
        result = classOrPath ? clsName.replace(File.separator, ".") : clsPath;
        this.resolveClassName.put(fileName + classOrPath, result);
        return result;
    }

    public void setPackages(List<String> packages) {
        this.packages = packages;
    }

    public void setJars(List<String> jars) {
        this.jars = jars;
    }

    public void setCode(char[] code) {
        this.code = code;
    }
}

