/*
 * Decompiled with CFR 0.152.
 */
package cn.ezeyc.edpenc.util;

import cn.ezeyc.edpenc.util.IoUtils;
import java.io.File;
import java.util.ArrayList;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.Descriptor;
import javassist.compiler.CompileError;
import javassist.compiler.Javac;

public class ClassUtils {
    public static byte[] rewriteAllMethods(ClassPool pool, String classname) {
        String name = null;
        try {
            CtMethod[] methods;
            CtClass cc = pool.getCtClass(classname);
            for (CtMethod m : methods = cc.getDeclaredMethods()) {
                CodeAttribute ca;
                name = m.getName();
                if (m.getName().contains("<") || !m.getLongName().startsWith(cc.getName()) || (ca = m.getMethodInfo().getCodeAttribute()) == null || ca.getCodeLength() == 1 || ca.getCode()[0] == -79) continue;
                ClassUtils.setBodyKeepParamInfos(m, null, true);
                if (!"void".equalsIgnoreCase(m.getReturnType().getName()) || m.getMethodInfo().getAccessFlags() != 9) continue;
                m.insertBefore("System.out.println(\"\\nStartup failed, invalid password.\\n\");");
            }
            return cc.toBytecode();
        }
        catch (Exception e) {
            System.out.println("[" + classname + "(" + name + ")]" + e.getMessage());
            throw new RuntimeException("[" + classname + "(" + name + ")]" + e.getMessage());
        }
    }

    public static void setBodyKeepParamInfos(CtMethod m, String src, boolean rebuild) throws CannotCompileException {
        CtClass cc = m.getDeclaringClass();
        if (cc.isFrozen()) {
            throw new RuntimeException(cc.getName() + " class is frozen");
        }
        CodeAttribute ca = m.getMethodInfo().getCodeAttribute();
        if (ca == null) {
            throw new CannotCompileException("no method body");
        }
        CodeIterator iterator = ca.iterator();
        Javac jv = new Javac(cc);
        try {
            int vars = jv.recordParams(m.getParameterTypes(), Modifier.isStatic((int)m.getModifiers()));
            jv.recordParamNames(ca, vars);
            jv.recordLocalVariables(ca, 0);
            jv.recordReturnType(Descriptor.getReturnType((String)m.getMethodInfo().getDescriptor(), (ClassPool)cc.getClassPool()), false);
            Bytecode b = jv.compileBody((CtBehavior)m, src);
            int stack = b.getMaxStack();
            int locals = b.getMaxLocals();
            if (stack > ca.getMaxStack()) {
                ca.setMaxStack(stack);
            }
            if (locals > ca.getMaxLocals()) {
                ca.setMaxLocals(locals);
            }
            int pos = iterator.insertEx(b.get());
            iterator.insert(b.getExceptionTable(), pos);
            if (rebuild) {
                m.getMethodInfo().rebuildStackMapIf6(cc.getClassPool(), cc.getClassFile2());
            }
        }
        catch (NotFoundException var12) {
            throw new CannotCompileException(var12);
        }
        catch (CompileError var13) {
            throw new CannotCompileException(var13);
        }
        catch (BadBytecode var14) {
            throw new CannotCompileException((Throwable)var14);
        }
    }

    public static void loadClassPath(ClassPool pool, File dir) {
        block7: {
            block6: {
                if (dir == null || !dir.exists()) {
                    return;
                }
                if (!dir.isDirectory()) break block6;
                ArrayList<File> jars = new ArrayList<File>();
                IoUtils.listFile(jars, dir, ".jar");
                for (File jar : jars) {
                    try {
                        pool.insertClassPath(jar.getAbsolutePath());
                    }
                    catch (NotFoundException notFoundException) {}
                }
                break block7;
            }
            if (!dir.getName().endsWith(".jar")) break block7;
            try {
                pool.insertClassPath(dir.getAbsolutePath());
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }
}

