/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.api.direct;

import cn.felord.payment.PayException;
import cn.felord.payment.wechat.enumeration.PayType;
import cn.felord.payment.wechat.v3.api.direct.InternalCombinePayApi;
import cn.felord.payment.wechat.v3.crypto.AppMerchant;
import cn.felord.payment.wechat.v3.crypto.WechatPaySigner;
import cn.felord.payment.wechat.v3.domain.direct.basepay.AppPayResponse;
import cn.felord.payment.wechat.v3.domain.direct.basepay.JsPayResponse;
import cn.felord.payment.wechat.v3.domain.direct.basepay.PrepayResponse;
import cn.felord.payment.wechat.v3.domain.direct.basepay.combine.CombineAppPayRequest;
import cn.felord.payment.wechat.v3.domain.direct.basepay.combine.CombineH5PayRequest;
import cn.felord.payment.wechat.v3.domain.direct.basepay.combine.CombineJsPayRequest;
import cn.felord.payment.wechat.v3.domain.direct.basepay.combine.CombineNativePayRequest;
import cn.felord.payment.wechat.v3.domain.direct.basepay.combine.CombinePayCloseParams;
import cn.felord.payment.wechat.v3.domain.direct.basepay.combine.CombinePayCloseRequest;
import cn.felord.payment.wechat.v3.domain.direct.basepay.combine.CombinePayDetailResponse;
import cn.felord.payment.wechat.v3.retrofit.WechatPayRetrofitFactory;
import cn.felord.utils.AlternativeJdkIdGenerator;
import java.time.Instant;

public class CombinePayApi {
    private final AlternativeJdkIdGenerator idGenerator;
    private final InternalCombinePayApi internalCombinePayApi;
    private final AppMerchant appMerchant;

    CombinePayApi(AlternativeJdkIdGenerator idGenerator, WechatPayRetrofitFactory factory, AppMerchant appMerchant) {
        this.idGenerator = idGenerator;
        this.internalCombinePayApi = (InternalCombinePayApi)factory.app(appMerchant).create(InternalCombinePayApi.class);
        this.appMerchant = appMerchant;
    }

    public AppPayResponse app(CombineAppPayRequest request) throws PayException {
        String mchid = this.appMerchant.merchantId();
        String appid = this.appMerchant.getAppid();
        PrepayResponse prepayResponse = this.internalCombinePayApi.prePay(PayType.APP.type(), request.toPayParams(appid, mchid));
        String timestamp = String.valueOf(Instant.now().getEpochSecond());
        String nonceStr = this.idGenerator.generate32();
        String preId = prepayResponse.getPrepayId();
        String paySign = WechatPaySigner.sign((AppMerchant)this.appMerchant, (String[])new String[]{appid, timestamp, nonceStr, preId});
        return new AppPayResponse(appid, mchid, preId, "Sign=WXPay", nonceStr, timestamp, null, paySign);
    }

    public PrepayResponse h5(CombineH5PayRequest request) throws PayException {
        String mchid = this.appMerchant.merchantId();
        String appid = this.appMerchant.getAppid();
        return this.internalCombinePayApi.prePay(PayType.H5.type(), request.toPayParams(appid, mchid));
    }

    public JsPayResponse jsapi(CombineJsPayRequest request) throws PayException {
        String mchid = this.appMerchant.merchantId();
        String appid = this.appMerchant.getAppid();
        PrepayResponse prepayResponse = this.internalCombinePayApi.prePay(PayType.JSAPI.type(), request.toPayParams(appid, mchid));
        String timestamp = String.valueOf(Instant.now().getEpochSecond());
        String nonceStr = this.idGenerator.generate32();
        String packageStr = "prepay_id=" + prepayResponse.getPrepayId();
        String paySign = WechatPaySigner.sign((AppMerchant)this.appMerchant, (String[])new String[]{appid, timestamp, nonceStr, packageStr});
        return new JsPayResponse(appid, timestamp, nonceStr, packageStr, "RSA", paySign);
    }

    public PrepayResponse nativePay(CombineNativePayRequest request) throws PayException {
        String mchid = this.appMerchant.merchantId();
        String appid = this.appMerchant.getAppid();
        return this.internalCombinePayApi.prePay(PayType.NATIVE.type(), request.toPayParams(appid, mchid));
    }

    public CombinePayDetailResponse queryTransactionByOutTradeNo(String combineOutTradeNo) throws PayException {
        return this.internalCombinePayApi.queryTransactionByOutTradeNo(combineOutTradeNo);
    }

    public boolean close(CombinePayCloseRequest request) throws PayException {
        String combineOutTradeNo = request.getCombineOutTradeNo();
        CombinePayCloseParams payParams = request.toPayParams(this.appMerchant.getAppid());
        return this.internalCombinePayApi.close(combineOutTradeNo, payParams).isSuccessful();
    }
}

