/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.api.direct;

import cn.felord.payment.PayException;
import cn.felord.payment.wechat.enumeration.PayType;
import cn.felord.payment.wechat.v3.api.direct.CombinePayApi;
import cn.felord.payment.wechat.v3.api.direct.InternalBasePayApi;
import cn.felord.payment.wechat.v3.crypto.AppMerchant;
import cn.felord.payment.wechat.v3.crypto.WechatPaySigner;
import cn.felord.payment.wechat.v3.domain.direct.basepay.AppNativePayRequest;
import cn.felord.payment.wechat.v3.domain.direct.basepay.AppPayResponse;
import cn.felord.payment.wechat.v3.domain.direct.basepay.BillUrlResponse;
import cn.felord.payment.wechat.v3.domain.direct.basepay.BufferSource;
import cn.felord.payment.wechat.v3.domain.direct.basepay.FundFlowBillRequest;
import cn.felord.payment.wechat.v3.domain.direct.basepay.H5PayRequest;
import cn.felord.payment.wechat.v3.domain.direct.basepay.JsPayRequest;
import cn.felord.payment.wechat.v3.domain.direct.basepay.JsPayResponse;
import cn.felord.payment.wechat.v3.domain.direct.basepay.MchId;
import cn.felord.payment.wechat.v3.domain.direct.basepay.PayDetailResponse;
import cn.felord.payment.wechat.v3.domain.direct.basepay.PrepayResponse;
import cn.felord.payment.wechat.v3.domain.direct.basepay.RefundRequest;
import cn.felord.payment.wechat.v3.domain.direct.basepay.RefundResponse;
import cn.felord.payment.wechat.v3.domain.direct.basepay.TradeBillRequest;
import cn.felord.payment.wechat.v3.retrofit.WechatPayRetrofitFactory;
import cn.felord.utils.AlternativeJdkIdGenerator;
import java.time.Instant;
import okhttp3.ResponseBody;

public class DirectBasePayApi {
    private final AlternativeJdkIdGenerator idGenerator = new AlternativeJdkIdGenerator();
    private final WechatPayRetrofitFactory factory;
    private final InternalBasePayApi internalBasePayApi;
    private final AppMerchant appMerchant;

    public DirectBasePayApi(WechatPayRetrofitFactory factory, AppMerchant appMerchant) {
        this.factory = factory;
        this.internalBasePayApi = (InternalBasePayApi)factory.app(appMerchant).create(InternalBasePayApi.class);
        this.appMerchant = appMerchant;
    }

    public JsPayResponse jsapi(JsPayRequest request) throws PayException {
        String mchid = this.appMerchant.merchantId();
        String appid = this.appMerchant.getAppid();
        PrepayResponse prepayResponse = this.internalBasePayApi.prePay(PayType.JSAPI.type(), request.toPayParams(appid, mchid));
        String timestamp = String.valueOf(Instant.now().getEpochSecond());
        String nonceStr = this.idGenerator.generate32();
        String packageStr = "prepay_id=" + prepayResponse.getPrepayId();
        String paySign = WechatPaySigner.sign((AppMerchant)this.appMerchant, (String[])new String[]{appid, timestamp, nonceStr, packageStr});
        return new JsPayResponse(appid, timestamp, nonceStr, packageStr, "RSA", paySign);
    }

    public AppPayResponse app(AppNativePayRequest request) throws PayException {
        String mchid = this.appMerchant.merchantId();
        String appid = this.appMerchant.getAppid();
        PrepayResponse prepayResponse = this.internalBasePayApi.prePay(PayType.APP.type(), request.toPayParams(appid, mchid));
        String timestamp = String.valueOf(Instant.now().getEpochSecond());
        String nonceStr = this.idGenerator.generate32();
        String preId = prepayResponse.getPrepayId();
        String paySign = WechatPaySigner.sign((AppMerchant)this.appMerchant, (String[])new String[]{appid, timestamp, nonceStr, preId});
        return new AppPayResponse(appid, mchid, preId, "Sign=WXPay", nonceStr, timestamp, "RSA", paySign);
    }

    public PrepayResponse nativePay(AppNativePayRequest request) throws PayException {
        String mchid = this.appMerchant.merchantId();
        String appid = this.appMerchant.getAppid();
        return this.internalBasePayApi.prePay(PayType.NATIVE.type(), request.toPayParams(appid, mchid));
    }

    public PrepayResponse h5(H5PayRequest request) throws PayException {
        String mchid = this.appMerchant.merchantId();
        String appid = this.appMerchant.getAppid();
        return this.internalBasePayApi.prePay(PayType.H5.type(), request.toPayParams(appid, mchid));
    }

    public PayDetailResponse queryTransactionById(String transactionId) throws PayException {
        return this.internalBasePayApi.queryTransactionById(transactionId, this.appMerchant.merchantId());
    }

    public PayDetailResponse queryTransactionByOutTradeNo(String outTradeNo) throws PayException {
        return this.internalBasePayApi.queryTransactionByOutTradeNo(outTradeNo, this.appMerchant.merchantId());
    }

    public boolean close(String outTradeNo) throws PayException {
        return this.internalBasePayApi.close(outTradeNo, new MchId(this.appMerchant.merchantId())).isSuccessful();
    }

    public RefundResponse refund(RefundRequest request) throws PayException {
        return this.internalBasePayApi.refund(request);
    }

    public RefundResponse queryRefundInfo(String outRefundNo) throws PayException {
        return this.internalBasePayApi.queryRefundInfo(outRefundNo);
    }

    public BufferSource downloadTradeBill(TradeBillRequest request) throws PayException {
        BillUrlResponse billUrlResponse = this.internalBasePayApi.downloadTradeBill(request.getBillDate(), request.getBillType(), request.getTarType());
        try (ResponseBody body = this.internalBasePayApi.download(billUrlResponse.getDownloadUrl());){
            BufferSource bufferSource = new BufferSource(body.contentType(), body.contentLength(), body.source());
            return bufferSource;
        }
    }

    public BufferSource downloadFundFlowBill(FundFlowBillRequest request) throws PayException {
        BillUrlResponse billUrlResponse = this.internalBasePayApi.downloadFundFlowBill(request.getBillDate(), request.getAccountType(), request.getTarType());
        try (ResponseBody body = this.internalBasePayApi.download(billUrlResponse.getDownloadUrl());){
            BufferSource bufferSource = new BufferSource(body.contentType(), body.contentLength(), body.source());
            return bufferSource;
        }
    }

    public CombinePayApi combinePay() {
        return new CombinePayApi(this.idGenerator, this.factory, this.appMerchant);
    }
}

