/*
 * Decompiled with CFR 0.152.
 */
package cn.fntop.core.interceptor;

import cn.fntop.core.annotation.Acri;
import cn.fntop.core.annotation.Acries;
import cn.fntop.core.processor.AcriProcessor;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class AcriIntercepter
implements HandlerInterceptor {
    private ApplicationContext context;

    public AcriIntercepter(ApplicationContext context) {
        this.context = context;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            Method method = ((HandlerMethod)handler).getMethod();
            Acries acries = method.getAnnotation(Acries.class);
            if (acries != null && acries.more().length > 0) {
                Arrays.stream(acries.more()).forEach(acri -> {
                    if (acri != null && acri.value() != null && acri.before()) {
                        ((AcriProcessor)this.context.getBean(acri.value())).doBefore(request, response, handler);
                    }
                });
            } else {
                Acri acri2 = method.getAnnotation(Acri.class);
                if (acri2 != null && acri2.value() != null && acri2.before()) {
                    ((AcriProcessor)this.context.getBean(acri2.value())).doBefore(request, response, handler);
                }
            }
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (handler instanceof HandlerMethod) {
            Method method = ((HandlerMethod)handler).getMethod();
            Acries acries = method.getAnnotation(Acries.class);
            if (acries != null && acries.more().length > 0) {
                Arrays.stream(acries.more()).forEach(acri -> {
                    if (acri != null && acri.value() != null && acri.during()) {
                        ((AcriProcessor)this.context.getBean(acri.value())).doDuring(request, response, handler, modelAndView);
                    }
                });
            } else {
                Acri acri2 = method.getAnnotation(Acri.class);
                if (acri2 != null && acri2.value() != null && acri2.during()) {
                    ((AcriProcessor)this.context.getBean(acri2.value())).doDuring(request, response, handler, modelAndView);
                }
            }
        }
        super.postHandle(request, response, handler, modelAndView);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (handler instanceof HandlerMethod) {
            Method method = ((HandlerMethod)handler).getMethod();
            Acries acries = method.getAnnotation(Acries.class);
            if (acries != null && acries.more().length > 0) {
                Arrays.stream(acries.more()).forEach(acri -> {
                    if (acri != null && acri.value() != null && acri.after()) {
                        ((AcriProcessor)this.context.getBean(acri.value())).doAfter(request, response, handler, ex);
                    }
                });
            } else {
                Acri acri2 = method.getAnnotation(Acri.class);
                if (acri2 != null && acri2.value() != null && acri2.after()) {
                    ((AcriProcessor)this.context.getBean(acri2.value())).doAfter(request, response, handler, ex);
                }
            }
        }
    }
}

