/*
 * Decompiled with CFR 0.152.
 */
package cn.fntop.core.processor;

import cn.fntop.core.processor.AcriProcessor;
import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;

@Component
public class AcriStopWatchProcessor
implements AcriProcessor {
    private static final Logger log = LoggerFactory.getLogger(AcriStopWatchProcessor.class);
    private ApplicationContext context;
    private final String prodProfile = "prod";
    private final TransmittableThreadLocal<StopWatch> STOP_WATCH = new TransmittableThreadLocal();

    public AcriStopWatchProcessor(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    @Override
    public void doBefore(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (!this.isProduction()) {
            StopWatch stopWatch = new StopWatch();
            this.STOP_WATCH.set((Object)stopWatch);
            stopWatch.start();
        }
    }

    @Override
    public void doDuring(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
    }

    @Override
    public void doAfter(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (!this.isProduction()) {
            StopWatch stopWatch = (StopWatch)this.STOP_WATCH.get();
            stopWatch.stop();
            log.info("[Acri]\u7ed3\u675f\u8bf7\u6c42 => URL[{}],\u8017\u65f6:[{}]\u6beb\u79d2", (Object)(request.getMethod() + " " + request.getRequestURI()), (Object)stopWatch.getTime());
            this.STOP_WATCH.remove();
        }
    }

    private boolean isJsonRequest(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType != null) {
            return StringUtils.startsWithIgnoreCase((CharSequence)contentType, (CharSequence)"application/json");
        }
        return false;
    }

    private boolean isProduction() {
        return this.getActiveProfile() != null && !Arrays.stream(this.getActiveProfile()).noneMatch("prod"::equals);
    }

    private String[] getActiveProfile() {
        return this.context == null ? null : this.context.getEnvironment().getActiveProfiles();
    }
}

