/*
 * Decompiled with CFR 0.152.
 */
package cn.fntop.core.aspect;

import cn.fntop.core.annotation.AcriAspect;
import cn.fntop.core.domain.AcriContainer;
import cn.hutool.core.collection.CollUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class AcriesAspect {
    private static final Logger log = LoggerFactory.getLogger(AcriesAspect.class);

    @Pointcut(value="@annotation(cn.fntop.core.annotation.AcriAspect)")
    public void pointcut() {
    }

    @Before(value="pointcut()")
    public void before(JoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Object[] params = joinPoint.getArgs();
        AcriAspect acri = method.getDeclaredAnnotation(AcriAspect.class);
        if (acri != null && acri.before()) {
            log.info("[AcriAspect:\u524d\u7f6e\u901a\u77e5\u5f00\u542f]");
            this.process(acri, acri.fallback(), acri.beforeMethod(), CollUtil.newArrayList((Object[])params), null, null);
        }
    }

    @AfterReturning(value="pointcut()", returning="returnVal")
    public void afterReturning(JoinPoint joinPoint, Object returnVal) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Object[] params = joinPoint.getArgs();
        AcriAspect acri = method.getDeclaredAnnotation(AcriAspect.class);
        if (acri != null && acri.after()) {
            log.info("[AcriAspect:\u540e\u7f6e\u901a\u77e5\u5f00\u542f]");
            this.process(acri, acri.fallback(), acri.afterMethod(), CollUtil.newArrayList((Object[])params), returnVal, null);
        }
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Object[] params = joinPoint.getArgs();
        AcriAspect acri = method.getDeclaredAnnotation(AcriAspect.class);
        ArrayList paramList = CollUtil.newArrayList((Object[])params);
        if (acri != null) {
            if (acri.around()) {
                log.info("[AcriAspect:\u73af\u7ed5\u901a\u77e5\u5f00\u542f\uff1a\u524d\u7f6e\u73af\u7ed5]");
                this.process(acri, acri.fallback(), acri.beforeAroundMethod(), paramList, null, null);
            }
            Object returnVal = joinPoint.proceed();
            if (acri.around()) {
                log.info("[AcriAspect:\u73af\u7ed5\u901a\u77e5\u5f00\u542f\uff1a\u540e\u7f6e\u73af\u7ed5]");
                this.process(acri, acri.fallback(), acri.afterAroundMethod(), paramList, returnVal, null);
            }
            return returnVal;
        }
        return null;
    }

    @AfterThrowing(value="pointcut()", throwing="ex")
    public void afterThrowing(JoinPoint joinPoint, Exception ex) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Object[] params = joinPoint.getArgs();
        AcriAspect acri = method.getDeclaredAnnotation(AcriAspect.class);
        if (acri != null && acri.throwing()) {
            log.info("[AcriAspect:\u5f02\u5e38\u901a\u77e5\u5f00\u542f]");
            this.process(acri, acri.fallback(), acri.throwingMethod(), CollUtil.newArrayList((Object[])params), null, ex);
        }
    }

    private void process(AcriAspect acri, Class<?> fallbackClass, String fallbackMethod, List<Object> params, Object returnVal, Exception ex) {
        Method callMethod = null;
        AcriContainer acriContainer = new AcriContainer();
        acriContainer.setException(ex);
        acriContainer.setResult(returnVal);
        acriContainer.setParams(params);
        try {
            callMethod = fallbackClass.getDeclaredMethod(fallbackMethod, AcriContainer.class);
        }
        catch (NoSuchMethodException e) {
            ArrayList<String> notice = new ArrayList<String>();
            if (acri.before()) {
                notice.add("before");
            }
            if (acri.after()) {
                notice.add("after");
            }
            if (acri.around()) {
                notice.add("around");
            }
            if (acri.throwing()) {
                notice.add("throwing");
            }
            log.error("\n[AcriesAspect =\u300b \u6ce8\u89e3\u65b9\u6cd5{}\u5728\u7c7b{}\u4e2d\u4e0d\u5b58\u5728\u6216\u53c2\u6570\u4e0d\u5bf9\u5e94]\n\u5f53\u524d\u5f00\u542f\u7684\u901a\u77e5=\u300b{}\n\u524d\u7f6e\u901a\u77e5\uff08before\uff09=\u300b\u901a\u77e5\u65b9\u6cd5\u9700\u8981\u65b9\u6cd5\u53c2\u6570\n\u540e\u7f6e\u901a\u77e5\uff08after\uff09=\u300b\u901a\u77e5\u65b9\u6cd5\u9700\u8981\u65b9\u6cd5\u53c2\u6570+\u8fd4\u56de\u503c\u53c2\u6570\n\u5f02\u5e38\u901a\u77e5\uff08throwing\uff09=\u300b\u901a\u77e5\u65b9\u6cd5\u9700\u8981\u5f02\u5e38\u53c2\u6570\n\u73af\u7ed5\u901a\u77e5\uff08around\uff09=\u300b\u524d\u7f6e\u901a\u77e5\u65b9\u6cd5\u9700\u8981\u65b9\u6cd5\u53c2\u6570\uff0c\u540e\u7f6e\u901a\u77e5\u65b9\u6cd5\u9700\u8981\u65b9\u6cd5\u53c2\u6570\u548c\u8fd4\u56de\u503c\u53c2\u6570", new Object[]{fallbackMethod, fallbackClass.getName(), StringUtils.join(notice, (String)",")});
            return;
        }
        boolean isStatic = Modifier.isStatic(callMethod.getModifiers());
        if (isStatic) {
            try {
                callMethod.invoke(null, acriContainer);
            }
            catch (IllegalAccessException e) {
                log.error("[AcriesAspect:IllegalAccessException] \u53c2\u6570\u65e0\u6cd5\u8bbf\u95ee");
            }
            catch (InvocationTargetException e) {
                log.error("[AcriesAspect:InvocationTargetException] \u8c03\u7528\u5931\u8d25");
            }
        } else {
            Object instance = null;
            try {
                instance = fallbackClass.newInstance();
            }
            catch (InstantiationException e) {
                log.error("[AcriesAspect:InstantiationException] \u5b9e\u4f8b\u5316\u5f02\u5e38");
                return;
            }
            catch (IllegalAccessException e) {
                log.error("[AcriesAspect:IllegalAccessException] \u7c7b\u65e0\u6cd5\u8bbf\u95ee");
                return;
            }
            try {
                callMethod.invoke(instance, acriContainer);
            }
            catch (IllegalAccessException e) {
                log.error("[AcriesAspect:IllegalAccessException] \u65b9\u6cd5\u65e0\u6cd5\u8bbf\u95ee");
            }
            catch (InvocationTargetException e) {
                log.error("[AcriesAspect:InvocationTargetException] \u8c03\u7528\u5931\u8d25");
            }
            catch (IllegalArgumentException e) {
                log.error("[AcriesAspect:IllegalArgumentException] \u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d");
            }
        }
    }
}

