/*
 * Decompiled with CFR 0.152.
 */
package cn.fntop.core.interceptor;

import cn.fntop.core.annotation.Acri;
import cn.fntop.core.annotation.Acries;
import cn.fntop.core.processor.AcriProcessor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class AcriInterceptor
implements HandlerInterceptor {
    private ApplicationContext context;

    public AcriInterceptor(ApplicationContext context) {
        this.context = context;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            Method method = ((HandlerMethod)handler).getMethod();
            Class clz = ((HandlerMethod)handler).getBeanType();
            Acries clzAcries = clz.getDeclaredAnnotation(Acries.class);
            Acri clzAcri = clz.getDeclaredAnnotation(Acri.class);
            Acries acries = method.getDeclaredAnnotation(Acries.class);
            Acri acri = method.getDeclaredAnnotation(Acri.class);
            LinkedHashSet<Class<? extends AcriProcessor>> beans = new LinkedHashSet<Class<? extends AcriProcessor>>();
            this.cacheAcriProcessor(clzAcries, clzAcri, beans, 0);
            this.cacheAcriProcessor(acries, acri, beans, 0);
            beans.forEach(b -> ((AcriProcessor)this.context.getBean(b)).doBefore(request, response, handler));
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (handler instanceof HandlerMethod) {
            Method method = ((HandlerMethod)handler).getMethod();
            Class clz = ((HandlerMethod)handler).getBeanType();
            Acries clzAcries = clz.getDeclaredAnnotation(Acries.class);
            Acri clzAcri = clz.getDeclaredAnnotation(Acri.class);
            Acries acries = method.getDeclaredAnnotation(Acries.class);
            Acri acri = method.getDeclaredAnnotation(Acri.class);
            LinkedHashSet<Class<? extends AcriProcessor>> beans = new LinkedHashSet<Class<? extends AcriProcessor>>();
            this.cacheAcriProcessor(clzAcries, clzAcri, beans, 1);
            this.cacheAcriProcessor(acries, acri, beans, 1);
            beans.forEach(b -> ((AcriProcessor)this.context.getBean(b)).doDuring(request, response, handler, modelAndView));
        }
        super.postHandle(request, response, handler, modelAndView);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (handler instanceof HandlerMethod) {
            Method method = ((HandlerMethod)handler).getMethod();
            Class clz = ((HandlerMethod)handler).getBeanType();
            Acries clzAcries = clz.getDeclaredAnnotation(Acries.class);
            Acri clzAcri = clz.getDeclaredAnnotation(Acri.class);
            Acries acries = method.getDeclaredAnnotation(Acries.class);
            Acri acri = method.getDeclaredAnnotation(Acri.class);
            LinkedHashSet<Class<? extends AcriProcessor>> beans = new LinkedHashSet<Class<? extends AcriProcessor>>();
            this.cacheAcriProcessor(clzAcries, clzAcri, beans, 2);
            this.cacheAcriProcessor(acries, acri, beans, 2);
            beans.forEach(b -> ((AcriProcessor)this.context.getBean(b)).doAfter(request, response, handler, ex));
        }
    }

    private void cacheAcriProcessor(Acries acries, Acri acri, Set<Class<? extends AcriProcessor>> beans, int step) {
        this.addBean(beans, step, acri);
        if (acries != null && acries.acries() != null) {
            Arrays.stream(acries.acries()).forEach(a -> this.addBean(beans, step, (Acri)a));
        }
    }

    private void addBean(Set<Class<? extends AcriProcessor>> beans, int step, Acri a) {
        if (a != null && a.value() != null) {
            boolean enabled = false;
            switch (step) {
                case 0: {
                    enabled = a.before();
                    break;
                }
                case 1: {
                    enabled = a.during();
                    break;
                }
                case 2: {
                    enabled = a.after();
                }
            }
            if (enabled) {
                beans.add(a.value());
            } else {
                beans.remove(a.value());
            }
        }
    }
}

