package cn.fntop.weixin.config;

import com.jfinal.weixin.sdk.api.ApiConfig;
import com.jfinal.wxaapp.WxaConfig;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;

/**
 * @author fn
 * @description
 * @date 2023/3/5 22:49
 */
@Getter
@Setter
@ConfigurationProperties(prefix = "fn.weixin")
public class FnConfig {
    private String urlPatterns = "/weixin/*";
    /**
     * 决定用小程序还是公众号
     */
    private String appIdKey;
    /**
     * 设为开发模式可以在开发阶段输出请求交互的 xml 与 json 数据
     */
    private Boolean devMode;
    /**
     * 避免本地将线上AccessToken冲掉,上线需要改变值
     */
    private String accessTokenCache="fn-weixin-cache#9845s";
    /**
     * 公众号配置
     */
    private List<ApiConfig> wxConfigs;
    /**
     * 小程序配置
     */
    private List<WxaConfig> wxaConfigs;


    private WxaMsgParser wxaMsgParser;
    private String jsonType;

    public FnConfig() {
        this.wxaMsgParser = WxaMsgParser.XML;
        this.jsonType = "jackson";
    }

}
