package cn.fntop.weixin.config;

import cn.fntop.weixin.Interceptor.MsgInterceptor;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Configuration;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.Validator;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.config.annotation.*;

import java.util.List;

/**
 * 微信自动配置
 *
 * @author fn
 */
@EnableCaching
@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties(FnConfig.class)
public class FnAutoConfiguration {
	@Configuration
	@RequiredArgsConstructor
	public static class MsgConfiguration implements WebMvcConfigurer {
		private final FnConfig properties;

		@Override
		public void addInterceptors(InterceptorRegistry registry) {
			String urlPattern = properties.getUrlPatterns();
			MsgInterceptor httpCacheInterceptor = new MsgInterceptor(properties);
			registry.addInterceptor(httpCacheInterceptor)
					.addPathPatterns(urlPattern);
		}

		@Override
		public void configurePathMatch(PathMatchConfigurer configurer) {

		}

		@Override
		public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {

		}

		@Override
		public void configureAsyncSupport(AsyncSupportConfigurer configurer) {

		}

		@Override
		public void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {

		}

		@Override
		public void addFormatters(FormatterRegistry registry) {

		}

		@Override
		public void addResourceHandlers(ResourceHandlerRegistry registry) {

		}

		@Override
		public void addCorsMappings(CorsRegistry registry) {

		}

		@Override
		public void addViewControllers(ViewControllerRegistry registry) {

		}

		@Override
		public void configureViewResolvers(ViewResolverRegistry registry) {

		}

		@Override
		public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {

		}

		@Override
		public void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> handlers) {

		}

		@Override
		public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {

		}

		@Override
		public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {

		}

		@Override
		public void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> resolvers) {

		}

		@Override
		public void extendHandlerExceptionResolvers(List<HandlerExceptionResolver> resolvers) {

		}

		@Override
		public Validator getValidator() {
			return null;
		}

		@Override
		public MessageCodesResolver getMessageCodesResolver() {
			return null;
		}
	}
}
