/*
 * Decompiled with CFR 0.152.
 */
package cn.fntop.weixin.config;

import cn.fntop.weixin.config.FnConfig;
import cn.fntop.weixin.config.WxConfigLoader;
import cn.fntop.weixin.config.WxaMsgParser;
import com.jfinal.json.IJsonFactory;
import com.jfinal.json.JacksonFactory;
import com.jfinal.kit.StrKit;
import com.jfinal.weixin.sdk.api.ApiConfig;
import com.jfinal.weixin.sdk.api.ApiConfigKit;
import com.jfinal.weixin.sdk.cache.IAccessTokenCache;
import com.jfinal.weixin.sdk.utils.JsonUtils;
import com.jfinal.wxaapp.WxaConfig;
import com.jfinal.wxaapp.WxaConfigKit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

@Configuration(proxyBeanMethods=false)
public class WeixinAppConfig
implements SmartInitializingSingleton {
    private final FnConfig config;
    private final List<IAccessTokenCache> tokenProviders;
    private final List<WxConfigLoader> configProviders;

    public void afterSingletonsInstantiated() {
        this.tokenProviders.sort((Comparator<IAccessTokenCache>)AnnotationAwareOrderComparator.INSTANCE);
        ApiConfigKit.setAccessTokenCache((IAccessTokenCache)this.tokenProviders.get(this.tokenProviders.size() - 1));
        this.configProviders.sort((Comparator<WxConfigLoader>)AnnotationAwareOrderComparator.INSTANCE);
        WxConfigLoader lastConfigLoader = this.configProviders.get(this.configProviders.size() - 1);
        ArrayList<ApiConfig> wxConfList = new ArrayList<ApiConfig>(lastConfigLoader.loadWx());
        for (ApiConfig apiConfig : wxConfList) {
            ApiConfig config = new ApiConfig();
            if (StrKit.notBlank((String)apiConfig.getAppId())) {
                config.setAppId(apiConfig.getAppId());
            }
            if (StrKit.notBlank((String)apiConfig.getAppSecret())) {
                config.setAppSecret(apiConfig.getAppSecret());
            }
            if (StrKit.notBlank((String)apiConfig.getToken())) {
                config.setToken(apiConfig.getToken());
            }
            if (StrKit.notBlank((String)apiConfig.getEncodingAesKey())) {
                config.setEncodingAesKey(apiConfig.getEncodingAesKey());
            }
            config.setEncryptMessage(apiConfig.isEncryptMessage());
            ApiConfigKit.putApiConfig((ApiConfig)config);
        }
        ArrayList<WxaConfig> wxaConfList = new ArrayList<WxaConfig>(lastConfigLoader.loadWxa());
        for (WxaConfig conf : wxaConfList) {
            WxaConfig config = new WxaConfig();
            if (StrKit.notBlank((String)conf.getAppId())) {
                config.setAppId(conf.getAppId());
            }
            if (StrKit.notBlank((String)conf.getAppSecret())) {
                config.setAppSecret(conf.getAppSecret());
            }
            if (StrKit.notBlank((String)conf.getToken())) {
                config.setToken(conf.getToken());
            }
            if (StrKit.notBlank((String)conf.getEncodingAesKey())) {
                config.setEncodingAesKey(conf.getEncodingAesKey());
            }
            config.setMessageEncrypt(conf.isMessageEncrypt());
            WxaConfigKit.setWxaConfig((WxaConfig)config);
        }
        boolean bl = this.config.getDevMode();
        ApiConfigKit.setDevMode((boolean)bl);
        if (WxaMsgParser.JSON == this.config.getWxaMsgParser()) {
            WxaConfigKit.useJsonMsgParser();
        }
        if ("jackson".equalsIgnoreCase(this.config.getJsonType())) {
            JsonUtils.setJsonFactory((IJsonFactory)JacksonFactory.me());
        }
    }

    public WeixinAppConfig(FnConfig config, List<IAccessTokenCache> tokenProviders, List<WxConfigLoader> configProviders) {
        this.config = config;
        this.tokenProviders = tokenProviders;
        this.configProviders = configProviders;
    }
}

