/*
 * Decompiled with CFR 0.152.
 */
package cn.fntop.weixin.controller;

import cn.fntop.weixin.utils.WebUtils;
import com.jfinal.kit.HttpKit;
import com.jfinal.kit.StrKit;
import com.jfinal.weixin.sdk.kit.MsgEncryptKit;
import com.jfinal.wxaapp.WxaConfigKit;
import com.jfinal.wxaapp.msg.IMsgParser;
import com.jfinal.wxaapp.msg.bean.WxaImageMsg;
import com.jfinal.wxaapp.msg.bean.WxaMsg;
import com.jfinal.wxaapp.msg.bean.WxaTextMsg;
import com.jfinal.wxaapp.msg.bean.WxaUserEnterSessionMsg;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.bind.annotation.RequestMapping;

public abstract class FnApiControllerAdapter {
    private static final Log logger = LogFactory.getLog(FnApiControllerAdapter.class);
    protected final HttpServletRequest request;
    protected final HttpServletResponse response;

    @RequestMapping(value={""})
    public void index() {
        String imXmlMsg = HttpKit.readData((HttpServletRequest)this.request);
        if (WxaConfigKit.isDevMode()) {
            System.out.println("\u63a5\u6536\u6d88\u606f:");
            System.out.println(imXmlMsg);
        }
        if (StrKit.isBlank((String)imXmlMsg)) {
            throw new RuntimeException("\u8bf7\u4e0d\u8981\u5728\u6d4f\u89c8\u5668\u4e2d\u8bf7\u6c42\u8be5\u8fde\u63a5,\u8c03\u8bd5\u8bf7\u67e5\u770bWIKI:http://git.oschina.net/jfinal/jfinal-weixin/wikis/JFinal-weixin-demo%E5%92%8C%E8%B0%83%E8%AF%95");
        }
        try {
            if (WxaConfigKit.getWxaConfig().isMessageEncrypt()) {
                imXmlMsg = MsgEncryptKit.decrypt((String)imXmlMsg, (String)this.request.getParameter("timestamp"), (String)this.request.getParameter("nonce"), (String)this.request.getParameter("msg_signature"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u4f7f\u7528\u5bc6\u6587\u6a21\u5f0f\uff0c\u89e3\u5bc6\u6d88\u606f\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4MessageEncrypt\u662f\u5426\u914d\u7f6e\u6b63\u786e");
        }
        IMsgParser msgParser = WxaConfigKit.getMsgParser();
        WxaMsg wxaMsg = msgParser.parser(imXmlMsg);
        if (wxaMsg instanceof WxaTextMsg) {
            this.processTextMsg((WxaTextMsg)wxaMsg);
        } else if (wxaMsg instanceof WxaImageMsg) {
            this.processImageMsg((WxaImageMsg)wxaMsg);
        } else if (wxaMsg instanceof WxaUserEnterSessionMsg) {
            this.processUserEnterSessionMsg((WxaUserEnterSessionMsg)wxaMsg);
        } else {
            logger.error((Object)("\u672a\u80fd\u8bc6\u522b\u7684\u5c0f\u7a0b\u5e8f\u6d88\u606f\u7c7b\u578b\u3002 \u6d88\u606f\u5185\u5bb9\u4e3a\uff1a\n" + imXmlMsg));
        }
        WebUtils.renderText(this.response, "success");
    }

    protected abstract void processTextMsg(WxaTextMsg var1);

    protected abstract void processImageMsg(WxaImageMsg var1);

    protected abstract void processUserEnterSessionMsg(WxaUserEnterSessionMsg var1);

    protected void renderDefault() {
        WebUtils.renderText(this.response, "");
    }

    public FnApiControllerAdapter(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }
}

