/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.util;

import cn.fyupeng.util.IpValid;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosUtils {
    private static final Logger log = LoggerFactory.getLogger(NacosUtils.class);
    private static String SERVER_ADDR = "127.0.0.1:8848";
    private static final NamingService namingService;
    private static final Set<String> serviceNames;
    private static InetSocketAddress inetSocketAddress;

    public static NamingService getNacosNamingService() {
        try {
            return NamingFactory.createNamingService((String)SERVER_ADDR);
        }
        catch (NacosException e) {
            log.error("error occurred when connecting to nacos server: ", (Throwable)e);
            return null;
        }
    }

    public static List<Instance> getAllInstance(String serviceName) throws NacosException {
        return namingService.getAllInstances(serviceName);
    }

    public static void registerService(String serviceName, InetSocketAddress address) throws NacosException {
        namingService.registerInstance(serviceName, address.getHostName(), address.getPort());
        inetSocketAddress = address;
        serviceNames.add(serviceName);
    }

    public static void clearRegistry() {
        if (!serviceNames.isEmpty() && inetSocketAddress != null) {
            String hostname = inetSocketAddress.getHostName();
            int port = inetSocketAddress.getPort();
            for (String serviceName : serviceNames) {
                try {
                    namingService.deregisterInstance(serviceName, hostname, port);
                }
                catch (NacosException e) {
                    log.error("Failed to cancel service:{}, info:{}", (Object)serviceName, (Object)e);
                }
            }
            log.info("All services on the nacos service have been cleaned up successfully");
        }
    }

    static {
        serviceNames = new HashSet<String>();
        namingService = NacosUtils.getNacosNamingService();
        Properties p = new Properties();
        try (InputStream is = NacosUtils.class.getClassLoader().getResourceAsStream("resource.properties");){
            if (is != null) {
                p.load(is);
                String propertyValue = p.getProperty("cn.fyupeng.nacos.register-addr");
                int pre = -1;
                String host = "";
                Integer port = 0;
                pre = propertyValue.indexOf(":");
                if (pre > 0 && pre == propertyValue.lastIndexOf(":")) {
                    host = propertyValue.substring(0, pre);
                    boolean valid = IpValid.valid(host);
                    if (valid) {
                        port = Integer.parseInt(propertyValue.substring(pre + 1));
                        SERVER_ADDR = propertyValue;
                    } else {
                        log.error("wrong ip address: {}", (Object)propertyValue);
                    }
                } else {
                    log.error("wrong ip address: {}", (Object)propertyValue);
                }
                log.info("Register center bind with address {}", (Object)propertyValue);
            } else {
                log.info("Register center bind with default address {}", (Object)SERVER_ADDR);
            }
        }
        catch (IOException e) {
            log.error("load resource error: ", (Throwable)e);
        }
    }
}

