/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectUtil {
    private static final Logger log = LoggerFactory.getLogger(ReflectUtil.class);

    public static String getStackTrace() {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        return stack[stack.length - 1].getClassName();
    }

    public static Set<Class<?>> getClasses(String packageName) {
        LinkedHashSet classSet = new LinkedHashSet();
        boolean recursive = true;
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    ReflectUtil.findAndAddClassesInPackageByFile(packageName, filePath, recursive, classSet);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.charAt(0) == '/') {
                            name = name.substring(1);
                        }
                        if (!name.startsWith(packageDirName)) continue;
                        int idx = name.lastIndexOf(47);
                        if (idx != -1) {
                            packageName = name.substring(0, idx).replace('/', '.');
                        }
                        if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                        String className = name.substring(packageName.length() + 1, name.length() - 6);
                        try {
                            classSet.add(Class.forName(packageName + "." + className));
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classSet;
    }

    private static void findAndAddClassesInPackageByFile(String packageName, String packagePath, final boolean recursive, Set<Class<?>> classSet) {
        File[] dirFiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirFiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                ReflectUtil.findAndAddClassesInPackageByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classSet);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classSet.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + "." + className));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

