/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.util;

import cn.fyupeng.util.IpUtils;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosUtils {
    private static final Logger log = LoggerFactory.getLogger(NacosUtils.class);
    private static String SERVER_ADDR = "127.0.0.1:8848";
    private static final NamingService namingService;
    private static final Set<String> serviceNames;
    private static InetSocketAddress inetSocketAddress;

    public static NamingService getNacosNamingService() {
        try {
            return NamingFactory.createNamingService((String)SERVER_ADDR);
        }
        catch (NacosException e) {
            log.error("error occurred when connecting to nacos server: ", (Throwable)e);
            return null;
        }
    }

    public static List<Instance> getAllInstance(String serviceName) throws NacosException {
        return namingService.getAllInstances(serviceName);
    }

    public static void registerService(String serviceName, InetSocketAddress address) throws NacosException {
        namingService.registerInstance(serviceName, address.getHostName(), address.getPort());
        log.info("host: {} has been registered on Register Center", (Object)address.getHostName());
        inetSocketAddress = address;
        serviceNames.add(serviceName);
    }

    public static void clearRegistry() {
        if (!serviceNames.isEmpty() && inetSocketAddress != null) {
            String hostname = inetSocketAddress.getHostName();
            int port = inetSocketAddress.getPort();
            for (String serviceName : serviceNames) {
                try {
                    namingService.deregisterInstance(serviceName, hostname, port);
                }
                catch (NacosException e) {
                    log.error("Failed to cancel service:{}, info:{}", (Object)serviceName, (Object)e);
                }
            }
            log.info("All services on the nacos service have been cleaned up successfully");
        }
    }

    static {
        serviceNames = new HashSet<String>();
        Properties p = new Properties();
        String currentWorkPath = System.getProperty("user.dir");
        InputStream is = null;
        String propertyValue = "";
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(currentWorkPath + "/config/resource.properties"));){
            p.load(bufferedReader);
            propertyValue = p.getProperty("cn.fyupeng.nacos.register-addr");
            log.info("read resource from resource path: {}", (Object)(currentWorkPath + "/config/resource.properties"));
        }
        catch (IOException e) {
            log.info("not found resource from resource path: {}", (Object)(currentWorkPath + "/config/resource.properties"));
            is = NacosUtils.class.getClassLoader().getResourceAsStream("resource.properties");
            if (is != null) {
                log.info("read resource from resource path: {}", (Object)NacosUtils.class.getClassLoader().getResource("resource.properties").getPath());
                try {
                    p.load(is);
                    propertyValue = p.getProperty("cn.fyupeng.nacos.register-addr");
                }
                catch (IOException ex) {
                    log.error("load resource error: ", (Throwable)ex);
                }
            }
            log.info("Register center bind with default address {}", (Object)SERVER_ADDR);
        }
        int pre = -1;
        String host = "";
        Integer port = 0;
        pre = propertyValue.indexOf(":");
        if (pre > 0 && pre == propertyValue.lastIndexOf(":")) {
            host = propertyValue.substring(0, pre);
            boolean valid = IpUtils.valid(host);
            if (valid) {
                host = propertyValue.substring(0, pre);
                port = Integer.parseInt(propertyValue.substring(pre + 1));
                SERVER_ADDR = host.equals("localhost") ? "127.0.0.1:" + port : propertyValue;
                log.info("Register center bind with address {}", (Object)propertyValue);
            } else {
                log.error("wrong ip address: {}", (Object)propertyValue);
            }
        } else if (!propertyValue.equals("")) {
            log.error("wrong ip address: {}", (Object)propertyValue);
        }
        namingService = NacosUtils.getNacosNamingService();
    }
}

