/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.protocol;

import cn.fyupeng.enums.ResponseCode;
import java.io.Serializable;

public class RpcResponse<T>
implements Serializable {
    private String requestId;
    private String checkCode;
    private Integer statusCode;
    private String message;
    private T data;

    public static <T> RpcResponse success(String requestId, String checkCode) {
        RpcResponse<T> response = new RpcResponse<T>();
        response.setStatusCode(ResponseCode.SUCCESS.getCode());
        response.setRequestId(requestId);
        response.setCheckCode(checkCode);
        response.setMessage("ok");
        return response;
    }

    public static <T> RpcResponse success(T data, String requestId, String checkCode) {
        RpcResponse<T> response = new RpcResponse<T>();
        response.setStatusCode(ResponseCode.SUCCESS.getCode());
        response.setRequestId(requestId);
        response.setCheckCode(checkCode);
        response.setData(data);
        response.setMessage("ok");
        return response;
    }

    public static <T> RpcResponse failure(String message, String requestId) {
        RpcResponse<T> response = new RpcResponse<T>();
        response.setStatusCode(ResponseCode.FAILURE.getCode());
        response.setRequestId(requestId);
        response.setMessage(message);
        return response;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getCheckCode() {
        return this.checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return "RpcResponse{requestId='" + this.requestId + '\'' + ", statusCode=" + this.statusCode + ", message='" + this.message + '\'' + ", data=" + this.data + '}';
    }
}

