/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.idworker;

import cn.fyupeng.idworker.exception.WorkerIdCantApplyException;
import cn.fyupeng.idworker.utils.JRedisHelper;
import cn.fyupeng.idworker.utils.LRedisHelper;
import cn.fyupeng.util.IpUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerIdServer {
    private static final Logger log = LoggerFactory.getLogger(WorkerIdServer.class);
    private static long workerId = 0L;
    private static String redisClientWay = "";

    private static void config() {
        block21: {
            String currentWorkPath = System.getProperty("user.dir");
            Object is = null;
            PropertyResourceBundle configResource = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(currentWorkPath + "/config/resource.properties"));){
                configResource = new PropertyResourceBundle(bufferedReader);
                redisClientWay = configResource.getString("cn.fyupeng.redis.client-way");
                if ("jedis".equals(redisClientWay) || "default".equals(redisClientWay) || StringUtils.isBlank((String)redisClientWay)) {
                    log.info("find redis client way attribute is jedis");
                    break block21;
                }
                if ("lettuce".equals(redisClientWay)) {
                    log.info("find redis client way attribute is lettuce");
                    break block21;
                }
                throw new RuntimeException("redis client way attribute is illegal!");
            }
            catch (MissingResourceException redisClientWayException) {
                log.warn("redis client way attribute is missing");
                log.info("use default redis client default way: jedis");
                redisClientWay = "jedis";
            }
            catch (IOException ioException) {
                block22: {
                    log.info("not found resource from resource path: {}", (Object)(currentWorkPath + "/config/resource.properties"));
                    try {
                        ResourceBundle resource = ResourceBundle.getBundle("resource");
                        redisClientWay = resource.getString("cn.fyupeng.redis.client-way");
                        if ("jedis".equals(redisClientWay) || "default".equals(redisClientWay) || StringUtils.isBlank((String)redisClientWay)) {
                            log.info("find redis client way attribute is jedis");
                            break block22;
                        }
                        if ("lettuce".equals(redisClientWay)) {
                            log.info("find redis client way attribute is lettuce");
                            break block22;
                        }
                        throw new RuntimeException("redis client way attribute is illegal!");
                    }
                    catch (MissingResourceException resourceException) {
                        log.info("not found resource from resource path: {}", (Object)"resource.properties");
                        log.info("use default redis client way: jedis");
                        redisClientWay = "jedis";
                    }
                }
                log.info("read resource from resource path: {}", (Object)"resource.properties");
            }
        }
    }

    private static void init() {
        if (workerId == 0L) {
            workerId = 1L;
            String hostName = IpUtils.getPubIpAddr();
            if ("jedis".equals(redisClientWay) || "default".equals(redisClientWay) || StringUtils.isBlank((String)redisClientWay)) {
                if (JRedisHelper.existsWorkerId(hostName)) {
                    workerId = Long.parseLong(JRedisHelper.getForHostName(hostName));
                } else {
                    int h = hostName.hashCode() & Integer.MAX_VALUE;
                    h ^= h >>> 16;
                    int id = h % 1024;
                    workerId = id;
                    if (!JRedisHelper.existsWorkerId(hostName)) {
                        long oldWorkerId = workerId;
                        while (JRedisHelper.existsWorkerIdSet(workerId)) {
                            if ((workerId = (workerId + 1L) % 1024L) != oldWorkerId) continue;
                            log.error("machine code node cannot be applied, nodes number has reached its maximum value");
                            throw new WorkerIdCantApplyException(String.format("Machine code node cannot be applied, Nodes number has reached its maximum value", new Object[0]));
                        }
                        JRedisHelper.setWorkerId(hostName, workerId);
                        JRedisHelper.setWorkerIdSet(workerId);
                    }
                }
            } else if (LRedisHelper.existsWorkerId(hostName) != 0L) {
                workerId = Long.parseLong(LRedisHelper.getForHostName(hostName));
            } else {
                int h = hostName.hashCode() & Integer.MAX_VALUE;
                h ^= h >>> 16;
                int id = h % 1024;
                workerId = id;
                if (LRedisHelper.exists(hostName) == 0L) {
                    long oldWorkerId = workerId;
                    while (LRedisHelper.existsWorkerIdSet(workerId)) {
                        if ((workerId = (workerId + 1L) % 1024L) != oldWorkerId) continue;
                        log.error("machine code node cannot be applied, nodes number has reached its maximum value");
                        throw new WorkerIdCantApplyException(String.format("Machine code node cannot be applied, Nodes number has reached its maximum value", new Object[0]));
                    }
                    LRedisHelper.asyncSetWorkerId(hostName, workerId);
                    LRedisHelper.asyncSetWorkerIdSet(workerId);
                }
            }
        }
    }

    public static long getWorkerId(int serverCode) {
        switch (serverCode) {
            case 0: {
                if ("jedis".equals(redisClientWay) || "default".equals(redisClientWay) || StringUtils.isBlank((String)redisClientWay)) {
                    return Long.parseLong(JRedisHelper.getForHostName(IpUtils.getPubIpAddr()));
                }
                return Long.parseLong(LRedisHelper.getForHostName(IpUtils.getPubIpAddr()));
            }
        }
        if ("jedis".equals(redisClientWay) || "default".equals(redisClientWay) || StringUtils.isBlank((String)redisClientWay)) {
            return Long.parseLong(JRedisHelper.getForHostName(IpUtils.getPubIpAddr()));
        }
        return Long.parseLong(LRedisHelper.getForHostName(IpUtils.getPubIpAddr()));
    }

    static {
        WorkerIdServer.config();
        WorkerIdServer.init();
    }
}

