/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.util;

import cn.fyupeng.enums.ResponseCode;
import cn.fyupeng.exception.ReceiveResponseException;
import cn.fyupeng.exception.RpcException;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.protocol.RpcResponse;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcMessageChecker {
    private static final Logger log = LoggerFactory.getLogger(RpcMessageChecker.class);
    private static final String INTERFACE_NAME = "interfaceName";

    public static boolean check(RpcRequest rpcRequest, RpcResponse rpcResponse) throws RpcException {
        if (rpcResponse == null) {
            log.error("service call failed, service: {}", (Object)rpcRequest.getInterfaceName());
            return false;
        }
        if (!rpcResponse.getRequestId().equals(rpcRequest.getRequestId())) {
            log.error("inconsistent request numbers");
            return false;
        }
        if (rpcResponse.getStatusCode() == null || !rpcResponse.getStatusCode().equals(ResponseCode.SUCCESS.getCode())) {
            log.error("service call failed, service: {}", (Object)rpcRequest.getInterfaceName());
            return false;
        }
        try {
            String checkCode = "";
            checkCode = rpcResponse.getData() == null ? null : new String(DigestUtils.md5((byte[])rpcResponse.getData().toString().getBytes("UTF-8")));
            if (rpcResponse.getCheckCode() == null) {
                if (checkCode != rpcResponse.getCheckCode()) {
                    log.error("data in package is modified\uff0c data: {}", rpcResponse.getData());
                    log.error("detail modification information: {}\uff0cthe modification information has been filtered, and such messages will not be received and consumed\uff01", (Object)rpcResponse.getData().toString());
                    return false;
                }
            } else if (!checkCode.equals(rpcResponse.getCheckCode())) {
                log.error("data in package is modified\uff0c data:{}", rpcResponse.getData());
                log.error("detail modification information: {}\uff0cthe modification information has been filtered, and such messages will not be received and consumed\uff01", (Object)rpcResponse.getData().toString());
                return false;
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("package is damaged, package:{}", (Object)rpcResponse);
            return false;
        }
        log.info("Packet verification succeeded!");
        return true;
    }

    public static void checkAndThrow(RpcRequest rpcRequest, RpcResponse rpcResponse) throws RpcException {
        if (rpcResponse == null) {
            log.error("service call failed, service: {}", (Object)rpcRequest.getInterfaceName());
            throw new ReceiveResponseException("service call failed Exception");
        }
        if (!rpcResponse.getRequestId().equals(rpcRequest.getRequestId())) {
            log.error("inconsistent request numbers");
            throw new ReceiveResponseException("inconsistent request numbers Exception");
        }
        if (rpcResponse.getStatusCode() == null || !rpcResponse.getStatusCode().equals(ResponseCode.SUCCESS.getCode())) {
            log.error("service call failed, service: {}", (Object)rpcRequest.getInterfaceName());
            throw new ReceiveResponseException("service call failed Exception");
        }
        try {
            String checkCode = "";
            checkCode = rpcResponse.getData() == null ? null : new String(DigestUtils.md5((byte[])rpcResponse.getData().toString().getBytes("UTF-8")));
            if (rpcResponse.getCheckCode() == null) {
                if (checkCode != rpcResponse.getCheckCode()) {
                    log.error("data in package is modified\uff0c data: {}", rpcResponse.getData());
                    log.error("detail modification information: {}\uff0cthe modification information has been filtered, and such messages will not be received and consumed\uff01", (Object)rpcResponse.getData().toString());
                    throw new ReceiveResponseException("data in package is modified Exception");
                }
            } else if (!checkCode.equals(rpcResponse.getCheckCode())) {
                log.error("data in package is modified\uff0c data:{}", rpcResponse.getData());
                log.error("detail modification information: {}\uff0cthe modification information has been filtered, and such messages will not be received and consumed\uff01", (Object)rpcResponse.getData().toString());
                throw new ReceiveResponseException("data in package is modified Exception");
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("package is damaged, package:{}", (Object)rpcResponse);
            throw new ReceiveResponseException("package is damaged Exception");
        }
        log.info("Packet verification succeeded!");
    }
}

