/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.idworker;

import cn.fyupeng.factory.ThreadPoolFactory;
import cn.fyupeng.idworker.exception.InvalidSystemClockException;
import java.security.SecureRandom;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdWorker {
    protected long epoch = 1288834974657L;
    protected long workerIdBits = 10L;
    protected long maxWorkerId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.workerIdBits;
    protected long sequenceBits;
    protected long workerIdShift = this.sequenceBits = 12L;
    protected long timestampLeftShift = this.sequenceBits + this.workerIdBits;
    protected long sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.sequenceBits;
    protected long lastMillis = -1L;
    protected final long workerId;
    protected long sequence = 0L;
    protected long thresholdMills = 500L;
    protected long thresholdSize = 3000L;
    private ConcurrentHashMap<Long, Long> timeStampMaxSequenceMap = new ConcurrentHashMap();
    private ExecutorService timeStampClearExecutorService = ThreadPoolFactory.createDefaultThreadPool("timestamp-clear-pool");
    protected Logger logger = LoggerFactory.getLogger(IdWorker.class);

    public IdWorker(long workerId) {
        this.workerId = this.checkWorkerId(workerId);
        this.logger.debug("worker starting. timestamp left shift {}, worker id {}", (Object)this.timestampLeftShift, (Object)workerId);
    }

    public long getEpoch() {
        return this.epoch;
    }

    private long checkWorkerId(long workerId) {
        if (workerId > this.maxWorkerId || workerId < 0L) {
            int rand = new SecureRandom().nextInt((int)this.maxWorkerId + 1);
            this.logger.warn("worker Id can't be greater than {} or less than 0, use a random {}", (Object)this.maxWorkerId, (Object)rand);
            return rand;
        }
        return workerId;
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized long nextId() {
        long timestamp;
        block12: {
            timestamp = this.millisGen();
            if (timestamp < this.lastMillis) {
                Long clockBackMaxSequence;
                long diff = this.lastMillis - timestamp;
                if (diff > 1000L) {
                    this.logger.warn("clock is moving backwards more then 1000ms");
                    this.logger.error("clock is moving backwards.  Rejecting requests until {}.", (Object)this.lastMillis);
                    throw new InvalidSystemClockException(String.format("Clock moved backwards.  Refusing to generate id for {} milliseconds", this.lastMillis - timestamp));
                }
                if (diff > 500L) {
                    this.logger.warn("clock is moving backwards more than 500ms");
                    long blockMillis = this.lastMillis - 500L;
                    timestamp = this.tilNextMillis(blockMillis);
                    clockBackMaxSequence = this.timeStampMaxSequenceMap.get(timestamp);
                    if (clockBackMaxSequence != null && clockBackMaxSequence < this.sequenceMask) {
                        this.sequence = clockBackMaxSequence + 1L;
                        this.timeStampMaxSequenceMap.put(timestamp, this.sequence);
                        break block12;
                    } else {
                        this.logger.error("clock is moving backwards.  Rejecting requests until {}.", (Object)this.lastMillis);
                        throw new InvalidSystemClockException(String.format("Clock moved backwards.  Refusing to generate id for {} milliseconds", this.lastMillis - timestamp));
                    }
                }
                this.logger.info("clock is moving backwards less than 500ms");
                clockBackMaxSequence = this.timeStampMaxSequenceMap.get(timestamp);
                if (clockBackMaxSequence != null && clockBackMaxSequence < this.sequenceMask) {
                    this.sequence = clockBackMaxSequence + 1L;
                    this.timeStampMaxSequenceMap.put(timestamp, this.sequence);
                } else {
                    timestamp = this.tilNextMillis(this.lastMillis);
                    this.sequence = 0L;
                }
            }
        }
        if (this.lastMillis == timestamp) {
            this.sequence = this.sequence + 1L & this.sequenceMask;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastMillis);
            }
        } else {
            this.sequence = 0L;
        }
        this.timeStampMaxSequenceMap.put(timestamp, this.sequence);
        if ((long)this.timeStampMaxSequenceMap.size() > this.thresholdSize) {
            this.timeStampClearExecutorService.execute(() -> this.timeStampMaxSequenceMap.keySet().stream().forEach(entryTimeStamp -> {
                if (this.lastMillis - entryTimeStamp > this.thresholdMills) {
                    this.timeStampMaxSequenceMap.remove(entryTimeStamp);
                }
            }));
        }
        if (timestamp > this.lastMillis) {
            this.lastMillis = timestamp;
        }
        long diff = timestamp - this.getEpoch();
        return diff << (int)this.timestampLeftShift | this.workerId << (int)this.workerIdShift | this.sequence;
    }

    protected long tilNextMillis(long lastMillis) {
        long millis = this.millisGen();
        while (millis <= lastMillis) {
            millis = this.millisGen();
        }
        return millis;
    }

    protected long millisGen() {
        return System.currentTimeMillis();
    }

    public long getLastMillis() {
        return this.lastMillis;
    }

    public long getWorkerId() {
        return this.workerId;
    }
}

