/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.factory;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolFactory {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolFactory.class);
    private static final int CORE_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    private static final int MAXIMUM_POOL_SIZE = 100;
    private static final int BLOCKING_QUEUE_CAPACITY = 400;
    private static final int KEEP_ALIVE_TIMEOUT = 1;
    private static Map<String, ExecutorService> threadPoolsMap = new ConcurrentHashMap<String, ExecutorService>();

    public static void main(String[] args) {
        ExecutorService test = ThreadPoolFactory.createDefaultThreadPool("test", null);
        System.out.println(test);
    }

    public static ExecutorService createDefaultThreadPool(String threadNamePrefix) {
        return ThreadPoolFactory.createDefaultThreadPool(threadNamePrefix, false);
    }

    public static ExecutorService createDefaultThreadPool(String threadNamePrefix, Boolean daemon) {
        ExecutorService pool = threadPoolsMap.computeIfAbsent(threadNamePrefix, k -> ThreadPoolFactory.createThreadPool(threadNamePrefix, daemon));
        if (pool.isShutdown() || pool.isTerminated()) {
            threadPoolsMap.remove(threadNamePrefix);
            pool = ThreadPoolFactory.createThreadPool(threadNamePrefix, daemon);
            threadPoolsMap.put(threadNamePrefix, pool);
        }
        return pool;
    }

    public static void shutdownAll() {
        log.info("close all ThreadPool...");
        threadPoolsMap.entrySet().parallelStream().forEach(entry -> {
            ExecutorService executorService = (ExecutorService)entry.getValue();
            executorService.shutdown();
            log.info("close threadPool [{}] [{}]", entry.getKey(), (Object)executorService.isTerminated());
            try {
                executorService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.error("Failed to close thread pool: ", (Throwable)e);
                executorService.shutdownNow();
            }
        });
        log.info("threadPool closed successfully");
    }

    private static ExecutorService createThreadPool(String threadNamePrefix, Boolean daemon) {
        ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(400);
        ThreadFactory threadFactory = ThreadPoolFactory.createThreadFactory(threadNamePrefix, daemon);
        return new ThreadPoolExecutor(CORE_POOL_SIZE, 100, 1L, TimeUnit.MINUTES, workQueue, threadFactory);
    }

    private static ThreadFactory createThreadFactory(String threadNamePrefix, Boolean daemon) {
        if (threadNamePrefix != null) {
            if (daemon != null) {
                return new ThreadFactoryBuilder().setNameFormat(threadNamePrefix + "-%d").setDaemon(daemon.booleanValue()).build();
            }
            return new ThreadFactoryBuilder().setNameFormat(threadNamePrefix + "-%d").build();
        }
        return Executors.defaultThreadFactory();
    }
}

